/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.KitManager;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.DirectoryUtils;
import org.terracotta.angela.common.util.FileUtils;

public class RemoteKitManager
extends KitManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteKitManager.class);
    private final Path workingKitInstallationPath;

    public RemoteKitManager(InstanceId instanceId, Distribution distribution, String kitInstallationName) {
        super(distribution);
        this.kitInstallationPath = this.rootInstallationPath.resolve(kitInstallationName);
        this.workingKitInstallationPath = Agent.WORK_DIR.resolve(instanceId.toString());
    }

    public File installKit(License license) {
        Path workingInstallPath = this.workingKitInstallationPath.resolve(this.distribution.getVersion().toString());
        Path workingCopyFromLocalInstall = this.createWorkingCopyFromLocalInstall(license, this.kitInstallationPath, workingInstallPath);
        logger.info("Working install is located in {}", (Object)workingCopyFromLocalInstall);
        return workingCopyFromLocalInstall.toFile();
    }

    private Path createWorkingCopyFromLocalInstall(License license, Path localInstall, Path workingInstallBasePath) {
        try {
            logger.info("Copying {} to {}", (Object)localInstall.toAbsolutePath(), (Object)workingInstallBasePath);
            Files.createDirectories(workingInstallBasePath, new FileAttribute[0]);
            DirectoryUtils.copyDirectory((Path)localInstall, (Path)workingInstallBasePath);
            if (license != null) {
                license.writeToFile(workingInstallBasePath.toFile());
            }
            FileUtils.cleanupPermissions((Path)workingInstallBasePath);
            return workingInstallBasePath;
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create working install", e);
        }
    }

    public Path getWorkingKitInstallationPath() {
        return this.workingKitInstallationPath;
    }

    public boolean verifyKitAvailability(boolean offline) {
        logger.debug("verifying if the extracted kit is already available locally to setup an install");
        if (!Files.isDirectory(this.kitInstallationPath, new LinkOption[0])) {
            logger.debug("Local kit installation is not available");
            return false;
        }
        return true;
    }

    public void deleteInstall(File installLocation) throws IOException {
        logger.info("deleting installation in {}", (Object)installLocation.getAbsolutePath());
        org.apache.commons.io.FileUtils.deleteDirectory((File)installLocation);
    }
}

