/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.client;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.JavaLocationResolver;
import org.terracotta.angela.common.util.LogOutputStream;
import org.terracotta.angela.common.util.OS;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.process.PidUtil;

public class RemoteClientManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteClientManager.class);
    private final JavaLocationResolver javaLocationResolver = new JavaLocationResolver();
    private static final String CLASSPATH_SUBDIR_NAME = "lib";
    private final File kitInstallationPath;

    public RemoteClientManager(InstanceId instanceId) {
        this.kitInstallationPath = Agent.WORK_DIR.resolve(instanceId.toString()).toFile();
    }

    public File getClientInstallationPath() {
        return this.kitInstallationPath;
    }

    public File getClientClasspathRoot() {
        return new File(this.kitInstallationPath, CLASSPATH_SUBDIR_NAME);
    }

    public ToolExecutionResult jcmd(int javaPid, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        String javaHome = this.javaLocationResolver.resolveJavaLocation(tcEnv).getHome();
        ArrayList<String> cmdLine = new ArrayList<String>();
        if (OS.INSTANCE.isWindows()) {
            cmdLine.add(javaHome + "\\bin\\jcmd.exe");
        } else {
            cmdLine.add(javaHome + "/bin/jcmd");
        }
        cmdLine.add(Integer.toString(javaPid));
        cmdLine.addAll(Arrays.asList(arguments));
        try {
            ProcessResult processResult = new ProcessExecutor(cmdLine).redirectErrorStream(true).readOutput(true).execute();
            return new ToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int spawnClient(final InstanceId instanceId, TerracottaCommandLineEnvironment tcEnv, Collection<String> joinedNodes) {
        try {
            String javaHome = this.javaLocationResolver.resolveJavaLocation(tcEnv).getHome();
            final AtomicBoolean started = new AtomicBoolean(false);
            ArrayList<String> cmdLine = new ArrayList<String>();
            if (OS.INSTANCE.isWindows()) {
                cmdLine.add(javaHome + "\\bin\\java.exe");
            } else {
                cmdLine.add(javaHome + "/bin/java");
            }
            if (!tcEnv.getJavaOpts().isEmpty()) {
                cmdLine.addAll(tcEnv.getJavaOpts());
            }
            cmdLine.add("-classpath");
            cmdLine.add(this.buildClasspath());
            cmdLine.add("-D" + AngelaProperties.PORT_RANGE.getPropertyName() + "=" + AngelaProperties.PORT_RANGE.getValue());
            cmdLine.add("-D" + AngelaProperties.DIRECT_JOIN.getPropertyName() + "=" + String.join((CharSequence)",", joinedNodes));
            cmdLine.add("-D" + AngelaProperties.NODE_NAME.getPropertyName() + "=" + instanceId);
            cmdLine.add("-D" + AngelaProperties.ROOT_DIR.getPropertyName() + "=" + Agent.ROOT_DIR);
            cmdLine.add(Agent.class.getName());
            logger.info("Spawning client {}", cmdLine);
            ProcessExecutor processExecutor = new ProcessExecutor().command(cmdLine).redirectOutput((OutputStream)new LogOutputStream(){

                protected void processLine(String line) {
                    ExternalLoggers.clientLogger.info("[{}] {}", (Object)instanceId, (Object)line);
                    if (line.equals("Agent is ready")) {
                        started.set(true);
                    }
                }
            }).directory(this.getClientInstallationPath());
            StartedProcess startedProcess = processExecutor.start();
            while (startedProcess.getProcess().isAlive() && !started.get()) {
                logger.debug("Waiting for spawned agent to be ready having PID: {}", (Object)PidUtil.getPid((Process)startedProcess.getProcess()));
                Thread.sleep(100L);
            }
            if (!startedProcess.getProcess().isAlive()) {
                throw new RuntimeException("Client process died in infancy");
            }
            int pid = PidUtil.getPid((Process)startedProcess.getProcess());
            logger.info("Spawned client with PID {}", (Object)pid);
            return pid;
        }
        catch (Exception e) {
            throw new RuntimeException("Error spawning client " + instanceId, e);
        }
    }

    private String buildClasspath() {
        String[] cpEntries = this.getClientClasspathRoot().list();
        if (cpEntries == null) {
            throw new RuntimeException("Cannot build client classpath before the classpath root is uploaded");
        }
        StringBuilder sb = new StringBuilder();
        for (String cpentry : cpEntries) {
            sb.append(CLASSPATH_SUBDIR_NAME).append(File.separator).append(cpentry).append(File.pathSeparator);
        }
        String agentClassName = Agent.class.getName().replace('.', '/');
        String agentClassPath = Agent.class.getResource("/" + agentClassName + ".class").getPath();
        if (agentClassPath.startsWith("file:")) {
            sb.append(agentClassPath, "file:".length(), agentClassPath.lastIndexOf(33));
        } else {
            sb.append(agentClassPath, 0, agentClassPath.lastIndexOf(agentClassName));
        }
        return sb.toString();
    }
}

