/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import java.io.Closeable;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.AddressResolver;
import org.apache.ignite.configuration.BasicAddressResolver;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.net.PortProvider;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.DirectoryUtils;
import org.terracotta.angela.common.util.HostAndIpValidator;
import org.terracotta.angela.common.util.HostPort;
import org.terracotta.angela.common.util.IgniteCommonHelper;
import org.terracotta.angela.common.util.IpUtils;

public class Agent {
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    private static final Logger logger;
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    public static final Path IGNITE_DIR;
    public static volatile AgentController controller;

    public static void main(String[] args) {
        Node node = Agent.startNode();
        Runtime.getRuntime().addShutdownHook(new Thread(node::close));
    }

    static Node startNode() {
        String nodeName = AngelaProperties.NODE_NAME.getValue();
        String directJoin = AngelaProperties.DIRECT_JOIN.getValue();
        ArrayList<String> nodesToJoin = new ArrayList<String>();
        if (directJoin != null) {
            for (String node : directJoin.split(",")) {
                if (node.trim().isEmpty()) continue;
                nodesToJoin.add(node);
            }
        }
        Node node = new Node(nodeName, nodesToJoin, PortProvider.SYS_PROPS);
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
        logger.debug("Agent started");
        return node;
    }

    static {
        System.setProperty("logback.configurationFile", "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.ROOT_DIR, (AngelaProperties)AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }

    public static class Node
    implements Closeable {
        private volatile Ignite ignite;

        public Node(String nodeName, List<String> nodesToJoin, PortProvider portProvider) {
            try {
                this.init(nodeName, nodesToJoin, portProvider);
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception subEx) {
                    e.addSuppressed(subEx);
                }
                throw e;
            }
        }

        private void init(String nodeName, List<String> nodesToJoin, PortProvider portProvider) {
            logger.info("Root directory is : " + ROOT_DIR);
            DirectoryUtils.createAndValidateDir((Path)ROOT_DIR);
            DirectoryUtils.createAndValidateDir((Path)WORK_DIR);
            DirectoryUtils.createAndValidateDir((Path)IGNITE_DIR);
            IgniteConfiguration cfg = new IgniteConfiguration();
            cfg.setIgniteHome(IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
            userAttributes.put("nodename", nodeName);
            cfg.setUserAttributes(userAttributes);
            if (!nodesToJoin.isEmpty()) {
                cfg.setIgniteInstanceName(nodeName);
            } else {
                cfg.setIgniteInstanceName("localhost");
            }
            boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
            cfg.setGridLogger((IgniteLogger)(enableLogging ? new Slf4jLogger() : new NullLogger()));
            cfg.setPeerClassLoadingEnabled(true);
            cfg.setMetricsLogFrequency(0L);
            if (nodesToJoin.isEmpty()) {
                logger.info("'{}' creating new isolated cluster", (Object)nodeName);
            } else {
                logger.info("'{}' joining isolated cluster on {}", (Object)nodeName, nodesToJoin);
            }
            ArrayList nodesToJoinHostnames = new ArrayList();
            HashMap hostnameToIpMapping = new HashMap();
            nodesToJoin.forEach(hostIpStr -> {
                String[] hostIp = hostIpStr.split("/");
                nodesToJoinHostnames.add(hostIp[0]);
                if (hostIp.length > 1) {
                    int lastColon = hostIp[0].lastIndexOf(":");
                    if (lastColon == -1 || HostAndIpValidator.isValidIPv6((String)hostIp[0])) {
                        hostnameToIpMapping.put(hostIp[0], hostIp[1]);
                    } else {
                        hostnameToIpMapping.put(hostIp[0].substring(0, lastColon), hostIp[1]);
                    }
                }
            });
            TcpDiscoverySpi spi = new TcpDiscoverySpi();
            spi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true).setAddresses(nodesToJoinHostnames));
            spi.setLocalPort(portProvider.getIgnitePort());
            spi.setJoinTimeout(10000L);
            spi.setLocalPortRange(portProvider.getIgnitePortRange());
            cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi().setLocalPortRange(portProvider.getIgnitePortRange()));
            cfg.setDiscoverySpi((DiscoverySpi)spi);
            if (!hostnameToIpMapping.isEmpty()) {
                logger.info("Adding address resolver for : " + hostnameToIpMapping);
                try {
                    cfg.setAddressResolver((AddressResolver)new BasicAddressResolver(hostnameToIpMapping));
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
                cfg.setLocalHost(IpUtils.getHostName());
            }
            try {
                this.ignite = Ignition.start((IgniteConfiguration)cfg);
                IgniteCommonHelper.checkForDuplicateAgent((Ignite)this.ignite, (String)nodeName);
            }
            catch (IgniteException e) {
                throw new RuntimeException("Error starting agent " + nodeName, e);
            }
            controller = new AgentController(this.ignite, nodesToJoin.isEmpty() ? Collections.singleton(new HostPort(nodeName, portProvider.getIgnitePort()).getHostPort()) : nodesToJoin, portProvider);
            logger.info("Registered node '" + nodeName + "'");
        }

        @Override
        public void close() {
            controller = null;
            if (this.ignite != null) {
                this.ignite.close();
                this.ignite = null;
            }
        }
    }
}

