/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.DirectoryUtils;
import org.terracotta.angela.common.util.IgniteCommonHelper;

public class Agent {
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    private static final Logger logger;
    private Ignite ignite;
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    public static final Path IGNITE_DIR;
    public static volatile AgentController controller;

    public static void main(String[] args) {
        Agent agent = new Agent();
        int ignitePort = Integer.parseInt(System.getProperty("angela.port", "40000"));
        agent.startCluster(Arrays.asList(AngelaProperties.DIRECT_JOIN.getValue().split(",")), AngelaProperties.NODE_NAME.getValue(), ignitePort);
        Runtime.getRuntime().addShutdownHook(new Thread(agent::close));
    }

    public void startCluster(Collection<String> peers, String nodeName, int ignitePort) {
        logger.info("Root directory is: {}", (Object)ROOT_DIR);
        logger.info("Nodename: {} added to cluster", (Object)nodeName);
        DirectoryUtils.createAndValidateDir((Path)ROOT_DIR);
        DirectoryUtils.createAndValidateDir((Path)WORK_DIR);
        DirectoryUtils.createAndValidateDir((Path)IGNITE_DIR);
        IgniteConfiguration cfg = new IgniteConfiguration();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
        userAttributes.put("nodename", nodeName);
        cfg.setUserAttributes(userAttributes);
        boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
        cfg.setGridLogger((IgniteLogger)(enableLogging ? new Slf4jLogger() : new NullLogger()));
        cfg.setPeerClassLoadingEnabled(true);
        cfg.setMetricsLogFrequency(0L);
        cfg.setIgniteInstanceName("ignite-" + ignitePort);
        logger.info("Connecting to peers (size = {}): ", (Object)peers.size());
        peers.forEach(peer -> logger.info("- {}", peer));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setLocalPort(ignitePort).setLocalPortRange(0).setJoinTimeout(10000L).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true).setAddresses(peers)));
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi().setLocalPort(ignitePort + 1).setLocalPortRange(0));
        try {
            logger.info("Starting ignite on {}", (Object)nodeName);
            this.ignite = Ignition.start((IgniteConfiguration)cfg);
            IgniteCommonHelper.displayCluster((Ignite)this.ignite);
        }
        catch (IgniteException e) {
            throw new RuntimeException("Error starting node " + nodeName, e);
        }
        controller = new AgentController(this.ignite, peers, ignitePort, (PortAllocator)new DefaultPortAllocator());
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
    }

    public void close() {
        if (this.ignite != null) {
            this.ignite.close();
            this.ignite = null;
        }
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    static {
        System.setProperty("logback.configurationFile", "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.ROOT_DIR, (AngelaProperties)AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }
}

