/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.util.DirectoryUtils;

public abstract class KitManager {
    private static final Logger logger = LoggerFactory.getLogger(KitManager.class);
    private static final long STALE_SNAPSHOT_LIMIT_HOURS = TimeUnit.DAYS.toHours(1L);
    protected final Distribution distribution;
    final Path rootInstallationPath;
    Path kitInstallationPath;

    KitManager(Distribution distribution) {
        this.distribution = distribution;
        this.rootInstallationPath = distribution == null ? null : this.buildRootInstallationPath(distribution);
    }

    private Path buildRootInstallationPath(Distribution distribution) {
        PackageType packageType = distribution.getPackageType();
        if (packageType != PackageType.KIT && packageType != PackageType.SAG_INSTALLER) {
            throw new RuntimeException("Can not resolve the local kit distribution package: " + packageType);
        }
        Path sagOrKitDir = Agent.ROOT_DIR.resolve(packageType == PackageType.SAG_INSTALLER ? "sag" : "kits");
        DirectoryUtils.createAndValidateDir((Path)sagOrKitDir);
        return sagOrKitDir.resolve(distribution.getVersion().getVersion(true));
    }

    boolean isValidLocalInstallerFilePath(boolean offline, Path localInstallerFile) {
        String md5FileHash;
        long timeSinceLastModified;
        if (!Files.isRegularFile(localInstallerFile, new LinkOption[0])) {
            logger.info("Kit {} is not an existing file", (Object)localInstallerFile.toAbsolutePath());
            return false;
        }
        try {
            timeSinceLastModified = System.currentTimeMillis() - Files.getLastModifiedTime(localInstallerFile, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!offline && this.distribution.getVersion().isSnapshot() && timeSinceLastModified > STALE_SNAPSHOT_LIMIT_HOURS * 60L * 60L * 1000L) {
            logger.info("Mode is online, distribution is snapshot, and {} is older than {} hours", (Object)localInstallerFile.getFileName(), (Object)STALE_SNAPSHOT_LIMIT_HOURS);
            DirectoryUtils.deleteQuietly((Path)localInstallerFile.getParent());
            return false;
        }
        if (this.distribution.getVersion().isSnapshot() || this.distribution.getPackageType() != PackageType.KIT) {
            return true;
        }
        String md5File = localInstallerFile.toAbsolutePath().toString() + ".md5";
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(md5File, new String[0]));
            md5FileHash = new String(bytes, StandardCharsets.US_ASCII).trim();
        }
        catch (NoSuchFileException nsfe) {
            logger.warn("{} does not have corresponding {} secure hash file on disk, considering it corrupt", (Object)localInstallerFile, (Object)md5File);
            DirectoryUtils.deleteQuietly((Path)localInstallerFile.getParent());
            return false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading " + md5File, ioe);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream fis = Files.newInputStream(localInstallerFile, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = fis.read(buffer)) != -1) {
                    md.update(buffer, 0, read);
                }
            }
            String localInstallerFileHash = DatatypeConverter.printHexBinary((byte[])md.digest());
            if (!localInstallerFileHash.equalsIgnoreCase(md5FileHash)) {
                logger.warn("{} secure hash does not match the contents of {} secure hash file on disk, considering it corrupt", (Object)localInstallerFile, (Object)md5File);
                DirectoryUtils.deleteQuietly((Path)localInstallerFile.getParent());
                return false;
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Missing MD5 secure hash implementation", nsae);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading " + localInstallerFile, ioe);
        }
        return true;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Path getKitInstallationPath() {
        return this.kitInstallationPath;
    }
}

