/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.KitManager;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.DirectoryUtils;

public class RemoteKitManager
extends KitManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteKitManager.class);
    private final Path workingKitInstallationPath;

    public RemoteKitManager(InstanceId instanceId, Distribution distribution, String kitInstallationName) {
        super(distribution);
        this.kitInstallationPath = this.rootInstallationPath.resolve(kitInstallationName);
        this.workingKitInstallationPath = Agent.WORK_DIR.resolve(instanceId.toString());
    }

    public File installKit(License license) {
        Path workingInstallPath = this.workingKitInstallationPath.resolve(this.distribution.getVersion().toString());
        Path workingCopyFromLocalInstall = this.createWorkingCopyFromLocalInstall(license, this.kitInstallationPath, workingInstallPath);
        logger.info("Working install is located in {}", (Object)workingCopyFromLocalInstall);
        return workingCopyFromLocalInstall.toFile();
    }

    private Path createWorkingCopyFromLocalInstall(License license, Path localInstall, Path workingInstallBasePath) {
        try {
            logger.info("Copying {} to {}", (Object)localInstall.toAbsolutePath(), (Object)workingInstallBasePath);
            Files.createDirectories(workingInstallBasePath, new FileAttribute[0]);
            DirectoryUtils.copyDirectory((Path)localInstall, (Path)workingInstallBasePath);
            if (license != null) {
                license.writeToFile(workingInstallBasePath.toFile());
            }
            this.cleanupPermissions(workingInstallBasePath);
            return workingInstallBasePath;
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create working install", e);
        }
    }

    private void cleanupPermissions(Path dest) {
        if (!FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dest, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String name = path.getFileName().toString();
                return name.endsWith(".sh") || name.endsWith("tms.jar");
            }).forEach(path -> {
                try {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(path, new LinkOption[0]));
                    perms.addAll(EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(path, perms);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public Path getWorkingKitInstallationPath() {
        return this.workingKitInstallationPath;
    }

    public boolean verifyKitAvailability(boolean offline) {
        logger.debug("verifying if the extracted kit is already available locally to setup an install");
        if (!Files.isDirectory(this.kitInstallationPath, new LinkOption[0])) {
            logger.debug("Local kit installation is not available");
            return false;
        }
        return true;
    }

    public void deleteInstall(File installLocation) throws IOException {
        logger.info("deleting installation in {}", (Object)installLocation.getAbsolutePath());
        FileUtils.deleteDirectory((File)installLocation);
    }
}

