/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.terracotta.angela.common.TerracottaServerInstance;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;

public class TerracottaInstall {
    private final File rootInstallLocation;
    private final Map<UUID, TerracottaServerInstance> terracottaServerInstances = new HashMap<UUID, TerracottaServerInstance>();

    public TerracottaInstall(File rootInstallLocation) {
        this.rootInstallLocation = rootInstallLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerracottaServerInstance getTerracottaServerInstance(TerracottaServer terracottaServer) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            return this.terracottaServerInstances.get(terracottaServer.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getInstallLocation(TerracottaServer terracottaServer) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            return this.terracottaServerInstances.get(terracottaServer.getId()).getInstallLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getLicenseFileLocation(TerracottaServer terracottaServer) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            return this.terracottaServerInstances.get(terracottaServer.getId()).getLicenseFileLocation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(TerracottaServer terracottaServer, File installLocation, License license, Distribution distribution, Topology topology) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            TerracottaServerInstance serverInstance = new TerracottaServerInstance(terracottaServer, installLocation, license, distribution, topology);
            this.terracottaServerInstances.put(terracottaServer.getId(), serverInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeServer(TerracottaServer terracottaServer) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            TerracottaServerInstance instance = this.terracottaServerInstances.remove(terracottaServer.getId());
            if (instance != null) {
                instance.close();
            }
            return this.terracottaServerInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int terracottaServerInstanceCount() {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            return this.terracottaServerInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installed(Distribution distribution) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            return this.terracottaServerInstances.values().stream().anyMatch(tsi -> tsi.getDistribution().equals((Object)distribution));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File installLocation(Distribution distribution) {
        Map<UUID, TerracottaServerInstance> map = this.terracottaServerInstances;
        synchronized (map) {
            TerracottaServerInstance terracottaServerInstance = this.terracottaServerInstances.values().stream().filter(tsi -> tsi.getDistribution().equals((Object)distribution)).findFirst().orElseThrow(() -> new RuntimeException("Distribution not installed : " + distribution));
            return terracottaServerInstance.getInstallLocation();
        }
    }

    public File getRootInstallLocation() {
        return this.rootInstallLocation;
    }
}

