/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.kit.KitManager;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.IpUtils;
import org.terracotta.utilities.io.Files;

public class RemoteKitManager
extends KitManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteKitManager.class);
    private final Path workingDir;

    public RemoteKitManager(InstanceId instanceId, Distribution distribution, String kitInstallationName) {
        super(distribution);
        this.kitInstallationPath = this.rootInstallationPath.resolve(kitInstallationName);
        Path workingDir = Agent.WORK_DIR.resolve(instanceId.toString());
        logger.info("Working directory is: {}", (Object)workingDir);
        this.workingDir = workingDir;
    }

    public File installKit(License license, Collection<String> serversHostnames) {
        try {
            Files.createDirectories(this.workingDir, new FileAttribute[0]);
            logger.info("should copy a separate kit install ? {}", (Object)AngelaProperties.KIT_COPY.getBooleanValue());
            if (IpUtils.areAllLocal(serversHostnames) && !AngelaProperties.KIT_COPY.getBooleanValue()) {
                logger.info("Skipped copying kit from {} to {}", (Object)this.kitInstallationPath.toAbsolutePath(), (Object)this.workingDir);
                if (license != null) {
                    license.writeToFile(this.workingDir.toFile());
                }
                return this.kitInstallationPath.toFile();
            }
            logger.info("Copying {} to {}", (Object)this.kitInstallationPath.toAbsolutePath(), (Object)this.workingDir);
            FileUtils.copy((Path)this.kitInstallationPath, (Path)this.workingDir, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, Files.ExtendedOption.RECURSIVE});
            if (license != null) {
                license.writeToFile(this.workingDir.toFile());
            }
            return this.workingDir.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create working install", e);
        }
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    public boolean isKitAvailable() {
        logger.debug("verifying if the extracted kit is already available locally to setup an install");
        if (!Files.isDirectory(this.kitInstallationPath, new LinkOption[0])) {
            logger.debug("Local kit installation is not available");
            return false;
        }
        return true;
    }

    public void deleteInstall(File installLocation) {
        logger.info("Deleting installation in {}", (Object)installLocation.getAbsolutePath());
        FileUtils.deleteQuietly((Path)installLocation.toPath());
    }
}

