/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.AgentController;
import org.terracotta.angela.agent.LocalAgentController;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.net.DefaultPortAllocator;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.util.AngelaVersion;
import org.terracotta.angela.common.util.FileUtils;
import org.terracotta.angela.common.util.IgniteCommonHelper;

public class Agent {
    public static final String AGENT_IS_READY_MARKER_LOG = "Agent is ready";
    public static final Path ROOT_DIR;
    public static final Path WORK_DIR;
    public static final Path IGNITE_DIR;
    private static final Logger logger;
    private static volatile Agent instance;
    private final AgentController controller;
    private final Ignite ignite;
    private final int igniteDiscoveryPort;
    private final int igniteComPort;

    private Agent(AgentController controller, Ignite ignite, int igniteDiscoveryPort, int igniteComPort) {
        this.controller = controller;
        this.ignite = ignite;
        this.igniteDiscoveryPort = igniteDiscoveryPort;
        this.igniteComPort = igniteComPort;
    }

    public String toString() {
        return this.ignite == null ? "local" : "localhost:" + this.igniteDiscoveryPort;
    }

    public static void main(String[] args) {
        int igniteDiscoveryPort = Integer.parseInt(System.getProperty("ignite.discovery.port"));
        int igniteComPort = Integer.parseInt(System.getProperty("ignite.com.port"));
        Agent agent = Agent.startCluster(Arrays.asList(AngelaProperties.DIRECT_JOIN.getValue().split(",")), AngelaProperties.NODE_NAME.getValue(), igniteDiscoveryPort, igniteComPort);
        Agent.setUniqueInstance(agent);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Agent.getInstance().close()));
    }

    public static Agent startLocalCluster() {
        logger.info("Root directory is: {}", (Object)ROOT_DIR);
        logger.info("Starting local only cluster");
        FileUtils.createAndValidateDir((Path)ROOT_DIR);
        FileUtils.createAndValidateDir((Path)WORK_DIR);
        Agent agent = new Agent(new LocalAgentController((PortAllocator)new DefaultPortAllocator()), null, 0, 0);
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
        return agent;
    }

    public static Agent startCluster(Collection<String> peers, String nodeName, int igniteDiscoveryPort, int igniteComPort) {
        Ignite ignite;
        logger.info("Root directory is: {}", (Object)ROOT_DIR);
        logger.info("Nodename: {} added to cluster", (Object)nodeName);
        FileUtils.createAndValidateDir((Path)ROOT_DIR);
        FileUtils.createAndValidateDir((Path)WORK_DIR);
        FileUtils.createAndValidateDir((Path)IGNITE_DIR);
        IgniteConfiguration cfg = new IgniteConfiguration();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        userAttributes.put("angela.version", AngelaVersion.getAngelaVersion());
        userAttributes.put("nodename", nodeName);
        cfg.setUserAttributes(userAttributes);
        boolean enableLogging = Boolean.getBoolean(AngelaProperties.IGNITE_LOGGING.getValue());
        cfg.setGridLogger((IgniteLogger)(enableLogging ? new Slf4jLogger() : new NullLogger()));
        cfg.setPeerClassLoadingEnabled(true);
        cfg.setMetricsLogFrequency(0L);
        cfg.setIgniteInstanceName("ignite-" + igniteDiscoveryPort);
        cfg.setIgniteHome(IGNITE_DIR.resolve(System.getProperty("user.name")).toString());
        logger.info("Connecting to peers (size = {}): {}", (Object)peers.size(), peers);
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setLocalPort(igniteDiscoveryPort).setLocalPortRange(0).setJoinTimeout(10000L).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true).setAddresses(peers)));
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi().setLocalPort(igniteComPort).setLocalPortRange(0));
        try {
            logger.info("Starting ignite on {}", (Object)nodeName);
            ignite = Ignition.start((IgniteConfiguration)cfg);
            IgniteCommonHelper.displayCluster((Ignite)ignite);
        }
        catch (IgniteException e) {
            throw new RuntimeException("Error starting node " + nodeName, e);
        }
        Agent agent = new Agent(new AgentController(ignite, peers, igniteDiscoveryPort, (PortAllocator)new DefaultPortAllocator()), ignite, igniteDiscoveryPort, igniteComPort);
        System.out.println(AGENT_IS_READY_MARKER_LOG);
        System.out.flush();
        return agent;
    }

    public int getIgniteDiscoveryPort() {
        return this.igniteDiscoveryPort;
    }

    public int getIgniteComPort() {
        return this.igniteComPort;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public AgentController getController() {
        return this.controller;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void close() {
        if (this.ignite != null) {
            this.ignite.close();
        }
    }

    public static synchronized Agent getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Agent not initialized");
        }
        return instance;
    }

    public static synchronized void setUniqueInstance(Agent agent) {
        if (instance != null) {
            throw new IllegalStateException("Agent already initialized to: " + instance);
        }
        logger.info("Installing agent: " + agent);
        instance = agent;
    }

    public static synchronized void removeUniqueInstance(Agent agent) {
        if (instance == null) {
            throw new IllegalStateException("Agent not initialized");
        }
        if (instance != agent) {
            throw new IllegalStateException("Unable to remove installed agent " + instance + ": caller has another agent " + agent);
        }
        logger.info("Uninstalling agent: " + agent);
        instance = null;
    }

    static {
        System.setProperty("logback.configurationFile", "angela-logback.xml");
        logger = LoggerFactory.getLogger(Agent.class);
        ROOT_DIR = Paths.get(AngelaProperties.getEitherOf((AngelaProperties)AngelaProperties.ROOT_DIR, (AngelaProperties)AngelaProperties.KITS_DIR), new String[0]);
        if (!ROOT_DIR.isAbsolute()) {
            throw new IllegalArgumentException("Expected ROOT_DIR to be an absolute path, got: " + ROOT_DIR);
        }
        WORK_DIR = ROOT_DIR.resolve("work");
        IGNITE_DIR = ROOT_DIR.resolve("ignite");
    }
}

