/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.Ignite;
import org.terracotta.angela.agent.cluster.AtomicBoolean;
import org.terracotta.angela.agent.cluster.AtomicCounter;
import org.terracotta.angela.agent.cluster.AtomicReference;
import org.terracotta.angela.agent.cluster.Barrier;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.common.clientconfig.ClientId;

public class Cluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Ignite ignite;
    private final AgentID from;
    private final ClientId clientId;

    public Cluster(Ignite ignite, AgentID from, ClientId clientId) {
        this.ignite = Objects.requireNonNull(ignite);
        this.from = Objects.requireNonNull(from);
        this.clientId = clientId;
    }

    public Barrier barrier(String name, int count) {
        return new Barrier(this.ignite, count, name);
    }

    public AtomicCounter atomicCounter(String name, long initialValue) {
        return new AtomicCounter(this.ignite, name, initialValue);
    }

    public AtomicBoolean atomicBoolean(String name, boolean initialValue) {
        return new AtomicBoolean(this.ignite, name, initialValue);
    }

    public <T> AtomicReference<T> atomicReference(String name, T initialValue) {
        return new AtomicReference<T>(this.ignite, name, initialValue);
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public AgentID getFromAgentId() {
        return this.from;
    }

    public AgentID getLocalAgentId() {
        return AgentID.valueOf((String)this.ignite.cluster().localNode().attribute("angela.nodeName"));
    }
}

