/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;

public class AgentExecutor {
    private final Executor executor;
    private final AgentID agentID;

    public AgentExecutor(Executor executor, AgentID agentID) {
        this.executor = executor;
        this.agentID = agentID;
    }

    public AgentID getTarget() {
        return this.agentID;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void execute(IgniteRunnable job) {
        this.executor.execute(this.agentID, job);
    }

    public Future<Void> executeAsync(IgniteRunnable job) {
        return this.executor.executeAsync(this.agentID, job);
    }

    public <R> R execute(IgniteCallable<R> job) {
        return this.executor.execute(this.agentID, job);
    }

    public <R> Future<R> executeAsync(IgniteCallable<R> job) {
        return this.executor.executeAsync(this.agentID, job);
    }

    public void uploadKit(InstanceId instanceId, Distribution distribution, String kitInstallationName, Path kitInstallationPath) throws IOException, InterruptedException {
        this.executor.uploadKit(this.agentID, instanceId, distribution, kitInstallationName, kitInstallationPath);
    }

    public void uploadClientJars(InstanceId instanceId, List<Path> locations) throws IOException, InterruptedException {
        this.executor.uploadClientJars(this.agentID, instanceId, locations);
    }
}

