/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.cluster.Cluster;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Exceptions;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.com.FileTransfer;
import org.terracotta.angela.agent.com.IgniteFutureAdapter;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.IpUtils;

public class IgniteLocalExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(IgniteLocalExecutor.class);
    protected final transient Map<String, AgentID> agents = new ConcurrentHashMap<String, AgentID>();
    protected final transient Map<AgentID, CountDownLatch> shutdowns = new ConcurrentHashMap<AgentID, CountDownLatch>();
    protected final UUID group;
    private final AgentID agentID;
    protected final Ignite ignite;

    public IgniteLocalExecutor(Agent agent) {
        this(agent.getGroupId(), agent.getAgentID(), agent.getIgnite());
    }

    public IgniteLocalExecutor(final UUID group, AgentID agentID, Ignite ignite) {
        this.group = group;
        this.agentID = agentID;
        this.ignite = ignite;
        this.agents.put(agentID.getHostname(), agentID);
        ignite.events(this.clusterGroup()).remoteListen((IgniteBiPredicate)new IgniteBiPredicate<UUID, Event>(){
            private static final long serialVersionUID = 1L;

            public boolean apply(UUID uuid, Event event) {
                if (event instanceof DiscoveryEvent) {
                    AgentID left = AgentID.valueOf((String)((DiscoveryEvent)event).eventNode().attribute("angela.nodeName"));
                    logger.info("Agent: {} has left cluster group: {}", (Object)left, (Object)group);
                    IgniteLocalExecutor.this.agents.values().remove(left);
                    CountDownLatch latch = IgniteLocalExecutor.this.shutdowns.remove(left);
                    if (latch != null) {
                        latch.countDown();
                    }
                }
                return true;
            }
        }, (IgnitePredicate)new IgnitePredicate<Event>(){
            private static final long serialVersionUID = 1L;

            public boolean apply(Event event) {
                return true;
            }
        }, new int[]{11});
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    @Override
    public void close() {
        this.getGroup().spawnedAgentIDs().filter(Predicate.isEqual(this.getLocalAgentID()).negate()).forEach(this::shutdown);
    }

    @Override
    public void uploadClientJars(AgentID agentID, InstanceId instanceId, List<Path> locations) {
        Future<Void> remoteDownloadFuture = this.executeAsync(agentID, (IgniteRunnable & Serializable)() -> this.downloadFiles(instanceId, new RemoteClientManager(instanceId).getClientClasspathRoot()));
        this.uploadFiles(instanceId, locations, remoteDownloadFuture);
    }

    @Override
    public void uploadKit(AgentID agentID, InstanceId instanceId, Distribution distribution, String kitInstallationName, Path kitInstallationPath) {
        Future<Void> remoteDownloadFuture = this.executeAsync(agentID, (IgniteRunnable & Serializable)() -> {
            RemoteKitManager remoteKitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            Path installDir = remoteKitManager.getKitInstallationPath().getParent();
            this.downloadFiles(instanceId, installDir);
        });
        this.uploadFiles(instanceId, Collections.singletonList(kitInstallationPath), remoteDownloadFuture);
    }

    @Override
    public void shutdown(AgentID agentID) {
        if (this.getLocalAgentID().equals(agentID)) {
            throw new IllegalArgumentException("Cannot kill myself: " + agentID);
        }
        CountDownLatch done = this.shutdowns.computeIfAbsent(agentID, a -> {
            AgentGroup group = this.getGroup();
            Collection spawned = group.spawnedAgentIDs().collect(Collectors.toSet());
            if (!group.contains(agentID)) {
                return null;
            }
            if (!spawned.contains(agentID)) {
                throw new IllegalArgumentException("Cannot kill inline agent: " + agentID);
            }
            logger.info("Requesting shutdown of agent: {}", (Object)agentID);
            try {
                this.execute(agentID, (IgniteRunnable & Serializable)() -> new Thread(){
                    {
                        this.setDaemon(true);
                    }

                    @Override
                    @SuppressFBWarnings(value={"DM_EXIT"})
                    public void run() {
                        System.exit(0);
                    }
                }.start());
            }
            catch (ClusterGroupEmptyException e) {
                logger.debug("Agent: {} has been closed concurrently through another mean", (Object)agentID);
                return null;
            }
            return new CountDownLatch(1);
        });
        if (done == null) {
            this.agents.values().remove(agentID);
            this.shutdowns.remove(agentID);
        } else {
            try {
                done.await();
            }
            catch (InterruptedException e) {
                throw Exceptions.rethrow(e);
            }
        }
    }

    public String toString() {
        return this.getLocalAgentID().toString();
    }

    @Override
    public AgentID getLocalAgentID() {
        return this.agentID;
    }

    @Override
    public synchronized Optional<AgentID> findAgentID(String hostname) {
        if (this.agents.containsKey(hostname)) {
            return Optional.of(this.agents.get(hostname));
        }
        if (IpUtils.isLocal((String)hostname)) {
            this.agents.put(hostname, this.getLocalAgentID());
            return Optional.of(this.getLocalAgentID());
        }
        List results = this.getGroup().getPeers().stream().filter(a -> a.getHostname().equals(hostname)).collect(Collectors.toList());
        if (results.isEmpty()) {
            return Optional.empty();
        }
        if (results.size() == 1) {
            return Optional.of(results.get(0));
        }
        throw new IllegalStateException("Found more than one agent for hostname: " + hostname + ": " + results);
    }

    @Override
    public synchronized AgentGroup getGroup() {
        AgentGroup agentGroup = new AgentGroup(this.group, this.clusterGroup().nodes().stream().collect(Collectors.toMap(clusterNode -> AgentID.valueOf((String)clusterNode.attribute("angela.nodeName")), clusterNode -> clusterNode.attributes().entrySet().stream().filter(e -> e.getValue() instanceof String).sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()), (s, s2) -> {
            throw new UnsupportedOperationException();
        }, LinkedHashMap::new)))));
        this.agents.values().retainAll(agentGroup.getPeers());
        agentGroup.remoteAgentIDs().filter(agentID -> !this.agents.containsValue(agentID)).forEach(newRemoteAgent -> {
            String hostname = newRemoteAgent.getHostname();
            AgentID known = this.agents.get(hostname);
            if (known == null) {
                logger.info("Discovered remote agent: {} for hostname: {}", newRemoteAgent, (Object)hostname);
                this.agents.put(hostname, (AgentID)newRemoteAgent);
            } else if (!newRemoteAgent.equals(known)) {
                throw new IllegalStateException("Agent: " + newRemoteAgent + " discovered, but we already know remote agent: " + known + " for hostname: " + hostname);
            }
        });
        return agentGroup;
    }

    @Override
    public Cluster getCluster() {
        return new Cluster(this.ignite, this.agentID, null);
    }

    @Override
    public Cluster getCluster(ClientId clientId) {
        return new Cluster(this.ignite, this.agentID, clientId);
    }

    @Override
    public Future<Void> executeAsync(AgentID agentID, IgniteRunnable job) {
        logger.debug("Executing job on: {}", (Object)agentID);
        return new IgniteFutureAdapter<Void>(agentID, this.ignite.compute(this.clusterGroup(agentID)).runAsync(job));
    }

    @Override
    public <R> Future<R> executeAsync(AgentID agentID, IgniteCallable<R> job) {
        logger.debug("Executing job on: {}", (Object)agentID);
        return new IgniteFutureAdapter(agentID, this.ignite.compute(this.clusterGroup(agentID)).callAsync(job));
    }

    @Override
    public BlockingQueue<FileTransfer> getFileTransferQueue(InstanceId instanceId) {
        return this.ignite.queue(instanceId + "@file-transfer-queue", 500, new CollectionConfiguration().setGroupName(this.group.toString()));
    }

    @Override
    public Optional<AgentID> startRemoteAgent(String hostname) {
        this.agents.putIfAbsent(hostname, this.getLocalAgentID());
        return Optional.empty();
    }

    private ClusterGroup clusterGroup() {
        return this.ignite.cluster().forAttribute("angela.group", (Object)this.group.toString());
    }

    private ClusterGroup clusterGroup(AgentID agentID) {
        ClusterGroup clusterGroup = this.ignite.cluster().forAttribute("angela.group", (Object)this.group.toString()).forAttribute("angela.nodeName", (Object)agentID.toString());
        if (clusterGroup.nodes().isEmpty()) {
            throw new ClusterGroupEmptyException("No agent found matching: " + agentID + " in group " + this.group);
        }
        if (clusterGroup.nodes().size() > 1) {
            throw new IllegalStateException("Several agents found matching: " + agentID + " in group " + this.group);
        }
        return clusterGroup;
    }
}

