/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.InMemoryDestFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.scp.SCPRemoteException;
import org.apache.commons.io.IOUtils;
import org.apache.ignite.Ignite;
import org.slf4j.Logger;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Exceptions;
import org.terracotta.angela.agent.com.IgniteLocalExecutor;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.util.AngelaVersions;
import org.terracotta.angela.common.util.ExternalLoggers;
import org.terracotta.angela.common.util.IpUtils;
import org.terracotta.angela.common.util.JDK;
import org.terracotta.angela.common.util.JavaLocationResolver;
import org.terracotta.angela.common.util.LogOutputStream;
import org.terracotta.angela.common.util.UniversalPath;

public class IgniteSshRemoteExecutor
extends IgniteLocalExecutor {
    private static final Logger logger = org.slf4j.LoggerFactory.getLogger(IgniteSshRemoteExecutor.class);
    private static final int MAX_LINE_LENGTH = 1024;
    private final transient Map<String, RemoteAgentHolder> clients = new HashMap<String, RemoteAgentHolder>();
    private transient String remoteUserName = AngelaProperties.SSH_USERNAME.getValue();
    private transient String remoteUserNameKeyPath = AngelaProperties.SSH_USERNAME_KEY_PATH.getValue();
    private transient TerracottaCommandLineEnvironment tcEnv = TerracottaCommandLineEnvironment.DEFAULT;
    private transient Path agentJarFile;
    private transient boolean agentJarFileShouldBeRemoved;
    private transient int port = Integer.parseInt(AngelaProperties.SSH_PORT.getValue());
    private transient boolean strictHostKeyChecking = AngelaProperties.SSH_STRICT_HOST_CHECKING.getBooleanValue();

    public IgniteSshRemoteExecutor(Agent agent) {
        super(agent);
    }

    public IgniteSshRemoteExecutor(UUID group, AgentID agentID, Ignite ignite) {
        super(group, agentID, ignite);
    }

    public IgniteSshRemoteExecutor setTcEnv(TerracottaCommandLineEnvironment tcEnv) {
        this.tcEnv = tcEnv;
        return this;
    }

    public IgniteSshRemoteExecutor setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
        return this;
    }

    public IgniteSshRemoteExecutor setRemoteUserNameKeyPath(String remoteUserNameKeyPath) {
        this.remoteUserNameKeyPath = remoteUserNameKeyPath;
        return this;
    }

    public IgniteSshRemoteExecutor setPort(int port) {
        this.port = port;
        return this;
    }

    public IgniteSshRemoteExecutor setStrictHostKeyChecking(boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
        return this;
    }

    private void initAgentJar() {
        if (this.agentJarFile != null) {
            return;
        }
        Map.Entry<Path, Boolean> agentJar = IgniteSshRemoteExecutor.findAgentJarFile();
        this.agentJarFile = agentJar.getKey();
        this.agentJarFileShouldBeRemoved = agentJar.getValue();
        if (this.agentJarFile == null) {
            throw new RuntimeException("agent JAR file not found, cannot use SSH remote agent launcher");
        }
    }

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public synchronized Optional<AgentID> startRemoteAgent(String hostname) {
        if (IpUtils.isLocal((String)hostname)) {
            this.agents.putIfAbsent(hostname, this.getLocalAgentID());
            return Optional.empty();
        }
        if (this.clients.containsKey(hostname)) {
            throw new IllegalArgumentException("Already have an SSH session opened for: " + hostname);
        }
        if (this.agents.containsKey(hostname)) {
            throw new IllegalArgumentException("Already have an Angela agent opened for: " + hostname);
        }
        logger.info("Connecting via SSH to: {}", (Object)hostname);
        this.initAgentJar();
        try {
            SSHClient ssh = new SSHClient();
            String angelaHome = ".angela/" + hostname;
            if (!this.strictHostKeyChecking) {
                ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            }
            try {
                ssh.loadKnownHosts();
            }
            catch (IOException e) {
                logger.warn("Unable to load SSH known hosts. Error: {}", (Object)e.getMessage(), (Object)e);
            }
            ssh.connect(hostname, this.port);
            if (this.remoteUserNameKeyPath == null) {
                ssh.authPublickey(this.remoteUserName);
            } else {
                ssh.authPublickey(this.remoteUserName, new String[]{this.remoteUserNameKeyPath});
            }
            Path baseDir = Agent.ROOT_DIR.resolve(angelaHome);
            Path jarsDir = baseDir.resolve("jars");
            IgniteSshRemoteExecutor.exec(ssh, "mkdir -p " + baseDir);
            IgniteSshRemoteExecutor.exec(ssh, "chmod a+w " + baseDir.getParent().toString());
            IgniteSshRemoteExecutor.exec(ssh, "chmod a+w " + baseDir);
            IgniteSshRemoteExecutor.exec(ssh, "mkdir -p " + jarsDir);
            IgniteSshRemoteExecutor.exec(ssh, "chmod a+w " + jarsDir);
            String dest = jarsDir.resolve(this.agentJarFile.getFileName()).toString().replace('\\', '/');
            if (this.agentJarFile.getFileName().toString().endsWith("-SNAPSHOT.jar") || !IgniteSshRemoteExecutor.exec(ssh, "[ -e " + dest + " ]").isPresent()) {
                logger.debug("Uploading agent jar: {} to: {}...", (Object)this.agentJarFile, (Object)hostname);
                ssh.newSCPFileTransfer().upload(this.agentJarFile.toString(), dest.toString());
            }
            Session session = ssh.startSession();
            session.allocatePTY("vt100", 320, 96, 0, 0, Collections.emptyMap());
            UniversalPath remoteJavaHome = this.findJavaHomeFromRemoteToolchains(ssh);
            String command = remoteJavaHome + "/bin/java " + String.join((CharSequence)" ", this.tcEnv.getJavaOpts()) + " -Dangela.process=spawned -Dangela.java.resolver=user -Dangela.group=" + this.group + " -Dangela.instanceName=" + "remote-agent" + " -Dangela.directJoin=" + String.join((CharSequence)",", this.getGroup().getPeerAddresses()) + " -D" + AngelaProperties.ROOT_DIR.getPropertyName() + "=" + baseDir + " -jar " + dest;
            if (logger.isDebugEnabled()) {
                logger.debug("Starting remote agent on: {} with: {}", (Object)hostname, (Object)command);
            } else {
                logger.info("Starting remote agent on: {}", (Object)hostname);
            }
            Session.Command cmd = session.exec(command);
            SshLogOutputStream sshLogOutputStream = new SshLogOutputStream(hostname, cmd);
            new StreamCopier(cmd.getInputStream(), (OutputStream)((Object)sshLogOutputStream), LoggerFactory.DEFAULT).bufSize(1024).spawnDaemon("stdout");
            new StreamCopier(cmd.getErrorStream(), (OutputStream)((Object)sshLogOutputStream), LoggerFactory.DEFAULT).bufSize(1024).spawnDaemon("stderr");
            AgentID agentID = sshLogOutputStream.waitForStartedState();
            logger.info("Agent: {} started on: {}", (Object)agentID, (Object)hostname);
            this.clients.put(hostname, new RemoteAgentHolder(hostname, ssh, session, cmd));
            String remoteHostname = agentID.getHostname();
            this.agents.put(hostname, agentID);
            this.agents.putIfAbsent(remoteHostname, agentID);
            return Optional.of(agentID);
        }
        catch (IOException | InterruptedException e) {
            RemoteAgentHolder holder = this.clients.remove(hostname);
            if (holder != null) {
                IgniteSshRemoteExecutor.safeClose(hostname, holder);
            }
            throw Exceptions.rethrow("Failed to launch Ignite agent at: " + this.remoteUserName + "@" + hostname + " (using SSH)", e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static Map.Entry<Path, Boolean> findAgentJarFile() {
        try {
            if (AngelaVersions.INSTANCE.isSnapshot()) {
                Path agentBaseDir;
                Path snapshotLocation = Paths.get(System.getProperty("user.home") + "/.m2/repository/org/terracotta/angela-agent/" + AngelaVersions.INSTANCE.getAngelaVersion() + "/angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar", new String[0]);
                if (Files.isRegularFile(snapshotLocation, new LinkOption[0])) {
                    logger.debug("Found agent jar at " + snapshotLocation);
                    return new AbstractMap.SimpleEntry<Path, Boolean>(snapshotLocation, false);
                }
                String projectBaseDir = System.getProperty("basedir");
                if (projectBaseDir != null && Files.isDirectory(agentBaseDir = Paths.get(projectBaseDir, new String[0]).getParent().resolve("agent"), new LinkOption[0]) && Files.isRegularFile(snapshotLocation = agentBaseDir.resolve("target").resolve("angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar"), new LinkOption[0])) {
                    logger.debug("Found agent jar at " + snapshotLocation);
                    return new AbstractMap.SimpleEntry<Path, Boolean>(snapshotLocation, false);
                }
                throw new RuntimeException("Agent SNAPSHOT jar file not found at " + snapshotLocation);
            }
            Path agentFile = Files.createTempDirectory("angela", new FileAttribute[0]).resolve("angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar");
            String releaseUrl = "https://search.maven.org/remotecontent?filepath=org/terracotta/angela-agent/" + AngelaVersions.INSTANCE.getAngelaVersion() + "/angela-agent-" + AngelaVersions.INSTANCE.getAngelaVersion() + ".jar";
            try (InputStream jarIs = new URL(releaseUrl).openStream();
                 OutputStream fileOutputStream = Files.newOutputStream(agentFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)jarIs, (OutputStream)fileOutputStream);
            }
            logger.debug("Installed agent jar from Nexus at " + agentFile);
            return new AbstractMap.SimpleEntry<Path, Boolean>(agentFile, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not get angela-agent jar: " + e.getMessage(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private static Optional<String> exec(SSHClient ssh, String line) throws TransportException, ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private UniversalPath findJavaHomeFromRemoteToolchains(SSHClient ssh) throws IOException {
        ByteArrayOutputStream baos;
        block5: {
            if (!this.tcEnv.isToolchainBased()) {
                Path javaHome = this.tcEnv.getJavaHome();
                logger.warn("Toolchain not used: will re-use the same current JVM path remotely on: {}: {}", (Object)ssh.getRemoteHostname(), (Object)javaHome);
                return UniversalPath.fromLocalPath((Path)javaHome);
            }
            baos = new ByteArrayOutputStream();
            InMemoryDestFile localFile = new InMemoryDestFile(){

                public OutputStream getOutputStream() {
                    return baos;
                }
            };
            try {
                logger.debug("Downloading toolchain.xml file from: {}", (Object)ssh.getRemoteHostname());
                ssh.newSCPFileTransfer().download("$HOME/.m2/toolchains.xml", (LocalDestFile)localFile);
            }
            catch (SCPRemoteException sre) {
                if (!sre.getMessage().contains("No such file or directory")) break block5;
                String remoteHomeDir = Stream.of(IgniteSshRemoteExecutor.exec(ssh, "env").get().split("\n")).filter(line -> line.startsWith("HOME=")).map(line -> line.substring(5)).findFirst().orElseThrow(() -> new UncheckedIOException((IOException)((Object)sre)));
                baos.reset();
                ssh.newSCPFileTransfer().download(remoteHomeDir + "/.m2/toolchains.xml", (LocalDestFile)localFile);
            }
        }
        JavaLocationResolver javaLocationResolver = new JavaLocationResolver((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        List jdks = javaLocationResolver.resolveJavaLocations(this.tcEnv.getJavaVersion(), this.tcEnv.getJavaVendors(), false);
        if (logger.isDebugEnabled()) {
            logger.debug("JDKs found on remote toolchain on: {} matching version: {} and vendors: {}\n - {}", new Object[]{ssh.getRemoteHostname(), this.tcEnv.getJavaVersion(), this.tcEnv.getJavaVendors(), jdks.stream().map(JDK::toString).collect(Collectors.joining("\n - "))});
        }
        for (JDK jdk : jdks) {
            UniversalPath remoteHome = jdk.getHome();
            if (!IgniteSshRemoteExecutor.exec(ssh, "[ -d \"" + remoteHome + "\" ]").isPresent()) continue;
            logger.info("Selected remote JDK on: {}: {}", (Object)ssh.getRemoteHostname(), (Object)jdk);
            return remoteHome;
        }
        throw new RuntimeException("No JDK configured in remote toolchains.xml is valid; wanted : " + this.tcEnv + ", found : " + jdks);
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void close() {
        if (this.agentJarFileShouldBeRemoved) {
            try {
                org.terracotta.utilities.io.Files.delete((Path)this.agentJarFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        UncheckedIOException uioe = null;
        for (Map.Entry<String, RemoteAgentHolder> entry : this.clients.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (UncheckedIOException e) {
                if (uioe == null) {
                    uioe = e;
                    continue;
                }
                uioe.addSuppressed(e);
            }
        }
        this.clients.clear();
        if (uioe != null) {
            throw uioe;
        }
        super.close();
    }

    private static void safeClose(String hostname, AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Error while cleaning up SSH agent on hostname: " + hostname, (Throwable)e);
        }
    }

    private static class SshLogOutputStream
    extends LogOutputStream {
        private final String serverName;
        private final Session.Command cmd;
        private final CountDownLatch started = new CountDownLatch(1);
        private final AtomicReference<AgentID> agentID = new AtomicReference();

        SshLogOutputStream(String serverName, Session.Command cmd) {
            this.serverName = serverName;
            this.cmd = cmd;
        }

        protected void processLine(String line) {
            ExternalLoggers.sshLogger.info("[{}] {}", (Object)this.serverName, (Object)line);
            if (line.startsWith("Agent is ready")) {
                this.agentID.set(AgentID.valueOf(line.substring("Agent is ready".length() + 2)));
                this.started.countDown();
            }
        }

        public AgentID waitForStartedState() throws InterruptedException {
            if (!this.cmd.isOpen()) {
                throw new RuntimeException("agent refused to start");
            }
            this.started.await();
            return this.agentID.get();
        }
    }

    private static class RemoteAgentHolder
    implements AutoCloseable {
        final String hostname;
        final SSHClient sshClient;
        final Session session;
        final Session.Command command;

        RemoteAgentHolder(String hostname, SSHClient sshClient, Session session, Session.Command command) {
            this.hostname = hostname;
            this.sshClient = sshClient;
            this.session = session;
            this.command = command;
        }

        @Override
        public void close() {
            logger.info("Cleaning up SSH agent on: {}", (Object)this.hostname);
            try {
                if (this.session.isOpen()) {
                    OutputStream os = this.session.getOutputStream();
                    os.write(3);
                }
            }
            catch (IOException e) {
                logger.debug("Error trying to closing SSH session. Maybe it is already closed ? Details: {}.", (Object)e.getMessage(), (Object)e);
            }
            finally {
                IgniteSshRemoteExecutor.safeClose(this.hostname, (AutoCloseable)this.command);
                IgniteSshRemoteExecutor.safeClose(this.hostname, (AutoCloseable)this.session);
                IgniteSshRemoteExecutor.safeClose(this.hostname, (AutoCloseable)this.sshClient);
            }
        }
    }
}

