/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;

public class FileTransfer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final FileTransfer END = new FileTransfer(null, null);
    private final String relativePath;
    private final byte[] bytes;

    private FileTransfer(String relativePath, byte[] bytes) {
        this.relativePath = relativePath;
        this.bytes = bytes;
    }

    public boolean isFinished() {
        return this.relativePath == null && this.bytes == null;
    }

    public String toString() {
        return this.relativePath;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void writeTo(Path root) {
        try {
            Path dest = root.resolve(this.relativePath);
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.write(dest, this.bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static FileTransfer from(Path root, Path file) {
        try {
            if (Files.isRegularFile(root, new LinkOption[0])) {
                if (!Objects.equals(root, file)) {
                    throw new IllegalStateException(root + " vs " + file);
                }
                return new FileTransfer(root.getFileName().toString(), Files.readAllBytes(file));
            }
            Path relWithBase = root.getFileName().resolve(root.relativize(file));
            ArrayList parts = new ArrayList(relWithBase.getNameCount());
            relWithBase.forEach(part -> parts.add(part.toString()));
            return new FileTransfer(String.join((CharSequence)"/", parts), Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

