/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.common.util.AngelaVersion;

public class AgentGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID id;
    private final Map<AgentID, Map<String, String>> peers = new LinkedHashMap<AgentID, Map<String, String>>();

    public AgentGroup(UUID id, Map<AgentID, Map<String, String>> peers) {
        this.id = id;
        this.peers.putAll(peers);
        for (Map.Entry<AgentID, Map<String, String>> entry : peers.entrySet()) {
            AgentID agentID = entry.getKey();
            Map<String, String> attrs = entry.getValue();
            if (!attrs.containsKey("angela.group") || !Objects.equals(attrs.get("angela.group"), id.toString())) {
                throw new IllegalStateException("Agent: " + agentID + " in group: " + attrs.get("angela.group") + " is not part of group: " + id);
            }
            if (attrs.containsKey("angela.version") && Objects.equals(attrs.get("angela.version"), AngelaVersion.getAngelaVersion())) continue;
            throw new IllegalStateException("Agent: " + agentID + " is running version [" + attrs.get("angela.version") + "] but the expected version is [" + AngelaVersion.getAngelaVersion() + "]");
        }
    }

    public UUID getId() {
        return this.id;
    }

    public Collection<AgentID> getPeers() {
        return this.peers.keySet();
    }

    public Stream<AgentID> remoteAgentIDs() {
        return this.getPeers().stream().filter(agentID -> agentID.getName().equals("remote-agent"));
    }

    public Stream<AgentID> spawnedAgentIDs() {
        return this.peers.entrySet().stream().filter(e -> Objects.equals("spawned", ((Map)e.getValue()).get("angela.process"))).map(Map.Entry::getKey);
    }

    public Collection<String> getPeerAddresses() {
        return this.getPeers().stream().map(AgentID::getAddress).map(Objects::toString).collect(Collectors.toList());
    }

    public String toString() {
        return this.getId() + "=" + this.getPeers();
    }

    public int size() {
        return this.peers.size();
    }

    public boolean isEmpty() {
        return this.peers.isEmpty();
    }

    public boolean contains(AgentID agentID) {
        return this.peers.containsKey(agentID);
    }

    public Stream<AgentID> stream() {
        return this.peers.keySet().stream();
    }

    public void forEach(Consumer<? super AgentID> action) {
        this.peers.keySet().forEach(action);
    }
}

