/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.cluster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;

public class AtomicBoolean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final IgniteAtomicLong igniteCounter;

    AtomicBoolean(Ignite ignite, String name, boolean initVal) {
        this.name = name;
        this.igniteCounter = ignite.atomicLong("Atomic-Boolean-" + name, initVal ? 1L : 0L, true);
    }

    public boolean get() {
        return this.igniteCounter.get() != 0L;
    }

    public void set(boolean value) {
        this.igniteCounter.getAndSet(value ? 1L : 0L);
    }

    public boolean getAndSet(boolean value) {
        return this.igniteCounter.getAndSet(value ? 1L : 0L) != 0L;
    }

    public boolean compareAndSet(boolean expVal, boolean newVal) {
        return this.igniteCounter.compareAndSet(expVal ? 1L : 0L, newVal ? 1L : 0L);
    }

    public String toString() {
        return this.name + ":" + this.get();
    }
}

