/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Version;
import org.terracotta.angela.common.util.FileUtils;

public abstract class KitResolver {
    private static final Logger logger = LoggerFactory.getLogger(KitResolver.class);

    public void init(PortAllocator portAllocator) {
    }

    public abstract Path resolveLocalInstallerPath(Version var1, LicenseType var2, PackageType var3);

    public abstract void createLocalInstallFromInstaller(Version var1, PackageType var2, License var3, Path var4, Path var5);

    public abstract Path resolveKitInstallationPath(Version var1, PackageType var2, Path var3, Path var4);

    public abstract URL[] resolveKitUrls(Version var1, LicenseType var2, PackageType var3);

    public abstract boolean supports(LicenseType var1);

    public void downloadLocalInstaller(Version version, LicenseType licenseType, PackageType packageType, Path localInstallerFile) {
        URL[] urls = this.resolveKitUrls(version, licenseType, packageType);
        URL kitUrl = urls[0];
        URL md5Url = urls[1];
        this.download(kitUrl, localInstallerFile);
        if (!version.isSnapshot() && packageType == PackageType.KIT) {
            this.download(md5Url, Paths.get(localInstallerFile + ".md5", new String[0]));
        }
        logger.debug("Success -> file downloaded successfully");
    }

    protected void download(URL url, Path dest) {
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            int contentLength = urlConnection.getContentLength();
            logger.debug("Downloading {} from {}", (Object)KitResolver.humanReadableByteCount(contentLength), (Object)url);
            KitResolver.createParentDirs(dest);
            long lastProgress = -1L;
            try (OutputStream fos = Files.newOutputStream(dest, new OpenOption[0]);
                 InputStream is = url.openStream();){
                int count;
                byte[] buffer = new byte[8192];
                long len = 0L;
                while ((count = is.read(buffer)) != -1) {
                    long progress = 100L * (len += (long)count) / (long)contentLength;
                    if (progress % 10L == 0L && progress > lastProgress) {
                        logger.debug("Download progress = {}%", (Object)progress);
                        lastProgress = progress;
                    }
                    fos.write(buffer, 0, count);
                }
            }
            logger.debug("Success -> file downloaded successfully");
        }
        catch (IOException e) {
            logger.debug("Deleting: " + dest.getParent() + " dir as it's messed up");
            FileUtils.deleteQuietly((Path)dest.getParent());
            throw new UncheckedIOException(e);
        }
    }

    private static String humanReadableByteCount(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    private static void createParentDirs(Path file) throws IOException {
        Objects.requireNonNull(file);
        Path parent = file.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

