/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.com.AgentExecutor;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Exceptions;
import org.terracotta.angela.agent.com.FileTransfer;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.FileUtils;

public interface Executor
extends AutoCloseable {
    public static final Logger logger = LoggerFactory.getLogger(Executor.class);

    public AgentID getLocalAgentID();

    public Optional<AgentID> findAgentID(String var1);

    public Optional<AgentID> startRemoteAgent(String var1);

    public AgentGroup getGroup();

    public Cluster getCluster();

    public Cluster getCluster(ClientId var1);

    public Future<Void> executeAsync(AgentID var1, IgniteRunnable var2);

    public <R> Future<R> executeAsync(AgentID var1, IgniteCallable<R> var2);

    public BlockingQueue<FileTransfer> getFileTransferQueue(InstanceId var1);

    @Override
    public void close();

    public void uploadClientJars(AgentID var1, InstanceId var2, List<Path> var3);

    public void uploadKit(AgentID var1, InstanceId var2, Distribution var3, String var4, Path var5);

    public void shutdown(AgentID var1) throws TimeoutException;

    default public void execute(AgentID agentID, IgniteRunnable job) {
        try {
            this.executeAsync(agentID, job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.asRuntime(e);
        }
    }

    default public <R> R execute(AgentID agentID, IgniteCallable<R> job) {
        try {
            return this.executeAsync(agentID, job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.asRuntime(e);
        }
    }

    default public AgentExecutor forAgent(AgentID agentID) {
        return new AgentExecutor(this, agentID);
    }

    default public AgentID getAgentID(String hostname) throws NoSuchElementException {
        return this.findAgentID(hostname).orElseThrow(() -> new NoSuchElementException(hostname));
    }

    default public void downloadFiles(InstanceId instanceId, Path dest) {
        try {
            FileTransfer fileTransfer;
            BlockingQueue<FileTransfer> queue = this.getFileTransferQueue(instanceId);
            logger.debug("Downloading files to: {}", (Object)dest);
            Files.createDirectories(dest, new FileAttribute[0]);
            while (!(fileTransfer = queue.take()).isFinished()) {
                fileTransfer.writeTo(dest);
                logger.debug("Downloaded: " + fileTransfer);
            }
            FileUtils.setCorrectPermissions((Path)dest);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void uploadFiles(InstanceId instanceId, List<Path> locations, Future<Void> remoteDownloadFuture) {
        try {
            try {
                BlockingQueue<FileTransfer> queue = this.getFileTransferQueue(instanceId);
                for (Path root : locations) {
                    logger.debug("Uploading files from: {}", (Object)root);
                    try {
                        Stream<Path> stream = Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                        Throwable throwable = null;
                        try {
                            stream.map(path -> FileTransfer.from(root, path)).forEach(fileTransfer -> {
                                try {
                                    queue.put((FileTransfer)fileTransfer);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new RuntimeException(e);
                                }
                                logger.debug("Uploaded: {}", fileTransfer);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                queue.put(FileTransfer.END);
            }
            finally {
                remoteDownloadFuture.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.asRuntime(e);
        }
    }
}

