/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc2.JdbcResultSet;

class JdbcStreamedPreparedStatement
extends JdbcPreparedStatement {
    private final IgniteDataStreamer<?, ?> streamer;

    JdbcStreamedPreparedStatement(JdbcConnection conn, String sql, IgniteDataStreamer<?, ?> streamer, PreparedStatement nativeStmt) {
        super(conn, sql);
        this.streamer = streamer;
        this.nativeStatement = nativeStmt;
    }

    @Override
    void closeInternal() throws SQLException {
        this.streamer.close(false);
        super.closeInternal();
    }

    @Override
    protected void execute0(String sql, Boolean isQuery) throws SQLException {
        assert (isQuery == null || !isQuery.booleanValue());
        long updCnt = this.conn.ignite().context().query().streamUpdateQuery(this.conn.cacheName(), this.conn.schemaName(), this.streamer, sql, this.getArgs());
        JdbcResultSet rs = new JdbcResultSet(this, updCnt);
        this.results = Collections.singletonList(rs);
        this.curRes = 0;
    }
}

