/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;

public final class GridCacheMultiTxFuture<K, V>
extends GridFutureAdapter<Boolean> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private Set<IgniteInternalTx> remainingTxs;

    public GridCacheMultiTxFuture(GridCacheContext<K, V> cctx) {
        if (log == null) {
            log = U.logger(cctx.kernalContext(), logRef, GridCacheMultiTxFuture.class);
        }
    }

    public void addTx(IgniteInternalTx tx) {
        if (this.remainingTxs == null) {
            this.remainingTxs = new GridConcurrentHashSet<IgniteInternalTx>();
        }
        this.remainingTxs.add(tx);
    }

    public void init() {
        if (this.remainingTxs == null) {
            this.remainingTxs = Collections.emptySet();
            this.onDone(true);
        } else {
            assert (!this.remainingTxs.isEmpty());
            for (final IgniteInternalTx tx : this.remainingTxs) {
                if (!tx.done()) {
                    tx.finishFuture().listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                        @Override
                        public void apply(IgniteInternalFuture<IgniteInternalTx> t) {
                            GridCacheMultiTxFuture.this.remainingTxs.remove(tx);
                            GridCacheMultiTxFuture.this.checkRemaining();
                        }
                    });
                    continue;
                }
                this.remainingTxs.remove(tx);
            }
            this.checkRemaining();
        }
    }

    private boolean checkRemaining() {
        if (this.remainingTxs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Finishing multi-tx future: " + this);
            }
            this.onDone(true);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheMultiTxFuture.class, this, "remaining", F.viewReadOnly(this.remainingTxs, CU.tx2xidVersion(), new IgnitePredicate[0]), "super", super.toString());
    }
}

