/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryResultsEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryResultsEnlistResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;

public final class NearTxQueryEnlistResultHandler
implements CI1<IgniteInternalFuture<Long>> {
    private static final long serialVersionUID = 5189735824793607906L;
    private static final NearTxQueryEnlistResultHandler INSTANCE = new NearTxQueryEnlistResultHandler();

    private NearTxQueryEnlistResultHandler() {
    }

    public static NearTxQueryEnlistResultHandler instance() {
        return INSTANCE;
    }

    public static <T extends GridNearTxQueryEnlistResponse> T createResponse(IgniteInternalFuture<?> future) {
        assert (future != null);
        Class<?> clazz = future.getClass();
        if (clazz == GridDhtTxQueryResultsEnlistFuture.class) {
            return (T)NearTxQueryEnlistResultHandler.createResponse((GridDhtTxQueryResultsEnlistFuture)future);
        }
        if (clazz == GridDhtTxQueryEnlistFuture.class) {
            return (T)NearTxQueryEnlistResultHandler.createResponse((GridDhtTxQueryEnlistFuture)future);
        }
        throw new IllegalStateException();
    }

    @NotNull
    private static GridNearTxQueryEnlistResponse createResponse(GridDhtTxQueryEnlistFuture future) {
        try {
            future.get();
            assert (future.tx.queryEnlisted() || future.cnt == 0L);
            return new GridNearTxQueryEnlistResponse(future.cctx.cacheId(), future.nearFutId, future.nearMiniId, future.nearLockVer, future.cnt, future.tx.empty() && !future.tx.queryEnlisted(), future.newDhtNodes);
        }
        catch (IgniteCheckedException e) {
            return new GridNearTxQueryEnlistResponse(future.cctx.cacheId(), future.nearFutId, future.nearMiniId, future.nearLockVer, e);
        }
    }

    @NotNull
    private static GridNearTxQueryResultsEnlistResponse createResponse(GridDhtTxQueryResultsEnlistFuture fut) {
        try {
            fut.get();
            GridCacheVersion ver = null;
            IgniteUuid id = null;
            if (fut.hasNearNodeUpdates) {
                ver = fut.cctx.tm().mappedVersion(fut.nearLockVer);
                id = fut.futId;
            }
            return new GridNearTxQueryResultsEnlistResponse(fut.cctx.cacheId(), fut.nearFutId, fut.nearMiniId, fut.nearLockVer, fut.cnt, ver, id, fut.newDhtNodes);
        }
        catch (IgniteCheckedException e) {
            return new GridNearTxQueryResultsEnlistResponse(fut.cctx.cacheId(), fut.nearFutId, fut.nearMiniId, fut.nearLockVer, e);
        }
    }

    @Override
    public void apply(IgniteInternalFuture<Long> fut0) {
        final GridDhtTxAbstractEnlistFuture fut = (GridDhtTxAbstractEnlistFuture)fut0;
        final GridCacheContext<?, ?> cctx = fut.cctx;
        final GridDhtTxLocal tx = (GridDhtTxLocal)fut.tx;
        final UUID nearNodeId = fut.nearNodeId;
        final Object res = NearTxQueryEnlistResultHandler.createResponse(fut);
        if (((GridNearTxQueryEnlistResponse)res).removeMapping()) {
            tx.forceSkipCompletedVersions();
            tx.rollbackDhtLocalAsync().listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                @Override
                public void apply(IgniteInternalFuture<IgniteInternalTx> fut0) {
                    try {
                        cctx.io().send(nearNodeId, (GridCacheMessage)res, cctx.ioPolicy());
                    }
                    catch (IgniteCheckedException e) {
                        U.error(fut.log, "Failed to send near enlist response [tx=" + CU.txString(tx) + ", node=" + nearNodeId + ", res=" + res + ']', e);
                        throw new GridClosureException(e);
                    }
                }
            });
            return;
        }
        try {
            cctx.io().send(nearNodeId, (GridCacheMessage)res, cctx.ioPolicy());
        }
        catch (IgniteCheckedException e) {
            U.error(fut.log, "Failed to send near enlist response (will rollback transaction) [tx=" + CU.txString(tx) + ", node=" + nearNodeId + ", res=" + res + ']', e);
            try {
                tx.rollbackDhtLocalAsync();
            }
            catch (Throwable e1) {
                e.addSuppressed(e1);
            }
            throw new GridClosureException(e);
        }
    }
}

