/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.evict;

import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionManager;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class PageAbstractEvictionTracker
implements PageEvictionTracker {
    private static final int COMPACT_TS_SHIFT = 8;
    private static final int DAY = 86400000;
    protected final PageMemoryNoStoreImpl pageMem;
    protected final int trackingSize;
    private final long baseCompactTs;
    private final GridCacheSharedContext sharedCtx;

    PageAbstractEvictionTracker(PageMemoryNoStoreImpl pageMem, DataRegionConfiguration plcCfg, GridCacheSharedContext sharedCtx) {
        this.pageMem = pageMem;
        this.sharedCtx = sharedCtx;
        this.trackingSize = pageMem.totalPages();
        this.baseCompactTs = U.currentTimeMillis() - 86400000L >> 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean evictDataPage(int pageIdx) throws IgniteCheckedException {
        List<CacheDataRowAdapter> rowsToEvict;
        long fakePageId = PageIdUtils.pageId(0, (byte)0, pageIdx);
        long page = this.pageMem.acquirePage(0, fakePageId);
        try {
            long pageAddr = this.pageMem.readLockForce(0, fakePageId, page);
            try {
                if (PageIO.getType(pageAddr) != 1) {
                    boolean bl = false;
                    return bl;
                }
                DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                long realPageId = PageIO.getPageId(pageAddr);
                if (!this.checkTouch(realPageId)) {
                    boolean bl = false;
                    return bl;
                }
                rowsToEvict = io.forAllItems(pageAddr, new AbstractDataPageIO.CC<CacheDataRowAdapter>(){

                    @Override
                    public CacheDataRowAdapter apply(long link) throws IgniteCheckedException {
                        CacheDataRowAdapter row = new CacheDataRowAdapter(link);
                        row.initFromLink(null, PageAbstractEvictionTracker.this.sharedCtx, PageAbstractEvictionTracker.this.pageMem, CacheDataRowAdapter.RowData.KEY_ONLY);
                        assert (row.cacheId() != 0) : "Cache ID should be stored in rows of evictable cache";
                        return row;
                    }
                });
            }
            finally {
                this.pageMem.readUnlock(0, fakePageId, page);
            }
        }
        finally {
            this.pageMem.releasePage(0, fakePageId, page);
        }
        boolean evictionDone = false;
        Iterator<CacheDataRowAdapter> iterator = rowsToEvict.iterator();
        while (iterator.hasNext()) {
            CacheDataRowAdapter dataRow = iterator.next();
            GridCacheContext cacheCtx = this.sharedCtx.cacheContext(dataRow.cacheId());
            if (!cacheCtx.userCache()) continue;
            GridCacheEntryEx entryEx = cacheCtx.isNear() ? cacheCtx.near().dht().entryEx(dataRow.key()) : cacheCtx.cache().entryEx(dataRow.key());
            evictionDone |= entryEx.evictInternal(GridCacheVersionManager.EVICT_VER, null, true);
        }
        return evictionDone;
    }

    protected abstract boolean checkTouch(long var1);

    final long compactTimestamp(long epochMilli) {
        return (epochMilli >> 8) - this.baseCompactTs;
    }

    int trackingIdx(int pageIdx) {
        return this.pageMem.pageSequenceNumber(pageIdx);
    }

    int pageIdx(int trackingIdx) {
        return this.pageMem.pageIndex(trackingIdx);
    }
}

