/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptedFileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.spi.encryption.EncryptionSpi;

public class EncryptedFileIOFactory
implements FileIOFactory {
    private static final long serialVersionUID = 0L;
    private FileIOFactory plainIOFactory;
    private int pageSize;
    private int headerSize;
    private int groupId;
    private GridEncryptionManager encMgr;
    private EncryptionSpi encSpi;

    EncryptedFileIOFactory(FileIOFactory plainIOFactory, int groupId, int pageSize, GridEncryptionManager encMgr, EncryptionSpi encSpi) {
        this.plainIOFactory = plainIOFactory;
        this.groupId = groupId;
        this.pageSize = pageSize;
        this.encMgr = encMgr;
        this.encSpi = encSpi;
    }

    @Override
    public FileIO create(File file) throws IOException {
        FileIO io = this.plainIOFactory.create(file);
        return new EncryptedFileIO(io, this.groupId, this.pageSize, this.headerSize, this.encMgr, this.encSpi);
    }

    @Override
    public FileIO create(File file, OpenOption ... modes) throws IOException {
        FileIO io = this.plainIOFactory.create(file, modes);
        return new EncryptedFileIO(io, this.groupId, this.pageSize, this.headerSize, this.encMgr, this.encSpi);
    }

    void headerSize(int headerSize) {
        this.headerSize = headerSize;
    }
}

