/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FileDownloader {
    private final IgniteLogger log;
    private static final int CHUNK_SIZE = 0x100000;
    private final Path path;
    private final AtomicLong size = new AtomicLong(-1L);
    private ServerSocketChannel serverChannel;
    private volatile GridFutureAdapter<?> finishFut;
    private final GridFutureAdapter<?> initFut = new GridFutureAdapter();

    public FileDownloader(IgniteLogger log, Path path) {
        this.log = log;
        this.path = path;
    }

    public InetSocketAddress start() throws IgniteCheckedException {
        try {
            ServerSocketChannel ch = ServerSocketChannel.open();
            ch.bind(null);
            this.serverChannel = ch;
            return (InetSocketAddress)ch.getLocalAddress();
        }
        catch (Exception ex) {
            throw new IgniteCheckedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(GridFutureAdapter<?> fut) {
        this.finishFut = fut;
        final ServerSocketChannel ch = this.serverChannel;
        fut.listen(new IgniteInClosureX<IgniteInternalFuture<?>>(){

            @Override
            public void applyx(IgniteInternalFuture<?> future) throws IgniteCheckedException {
                try {
                    if (FileDownloader.this.log != null && FileDownloader.this.log.isInfoEnabled()) {
                        FileDownloader.this.log.info("Server socket closed " + ch.getLocalAddress());
                    }
                    ch.close();
                }
                catch (Exception ex) {
                    U.error(FileDownloader.this.log, "Fail close socket.", ex);
                    throw new IgniteCheckedException(ex);
                }
            }
        });
        AbstractInterruptibleChannel writeChannel = null;
        AbstractInterruptibleChannel readChannel = null;
        try {
            File cacheWorkDir;
            File f = new File(this.path.toUri().getPath());
            if (f.exists()) {
                f.delete();
            }
            if (!(cacheWorkDir = f.getParentFile()).exists()) {
                cacheWorkDir.mkdir();
            }
            writeChannel = FileChannel.open(this.path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            this.initFut.onDone();
            readChannel = this.serverChannel.accept();
            long size = this.size.get();
            for (long pos = 0L; size == -1L || pos < size; pos += ((FileChannel)writeChannel).transferFrom((ReadableByteChannel)((Object)readChannel), pos, 0x100000L)) {
                if (size != -1L) continue;
                size = this.size.get();
            }
        }
        catch (IOException ex) {
            this.initFut.onDone(ex);
            fut.onDone(ex);
        }
        finally {
            try {
                if (writeChannel != null) {
                    writeChannel.close();
                }
            }
            catch (IOException ex) {
                throw new IgniteException("Could not close file: " + this.path);
            }
            try {
                if (readChannel != null) {
                    readChannel.close();
                }
            }
            catch (IOException ex) {
                throw new IgniteException("Could not close socket");
            }
        }
    }

    public void download(long size, Throwable th) {
        try {
            this.initFut.get();
            if (th != null) {
                this.finishFut.onDone(th);
            } else if (!this.size.compareAndSet(-1L, size)) {
                this.finishFut.onDone(new IgniteException("Size mismatch: " + this.size.get() + " != " + size));
            } else {
                this.finishFut.onDone();
            }
        }
        catch (IgniteCheckedException e) {
            this.finishFut.onDone(e);
        }
    }
}

