/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteReducer;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryRequest
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private long id;
    private String cacheName;
    private GridCacheQueryType type;
    private boolean fields;
    @GridToStringInclude(sensitive=true)
    private String clause;
    private String clsName;
    @GridDirectTransient
    private IgniteBiPredicate<Object, Object> keyValFilter;
    private byte[] keyValFilterBytes;
    @GridDirectTransient
    private IgniteReducer<Object, Object> rdc;
    private byte[] rdcBytes;
    @GridDirectTransient
    private IgniteClosure<?, ?> trans;
    private byte[] transBytes;
    @GridDirectTransient
    private Object[] args;
    private byte[] argsBytes;
    private int pageSize;
    private boolean incBackups;
    private boolean cancel;
    private boolean incMeta;
    private boolean all;
    private boolean keepBinary;
    private UUID subjId;
    private int taskHash;
    private int part = -1;
    private AffinityTopologyVersion topVer;
    private MvccSnapshot mvccSnapshot;

    public GridCacheQueryRequest() {
    }

    public GridCacheQueryRequest(int cacheId, long id, boolean fields, AffinityTopologyVersion topVer, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.id = id;
        this.fields = fields;
        this.topVer = topVer;
        this.addDepInfo = addDepInfo;
        this.cancel = true;
    }

    public GridCacheQueryRequest(int cacheId, long id, String cacheName, int pageSize, boolean incBackups, boolean fields, boolean all, boolean keepBinary, UUID subjId, int taskHash, AffinityTopologyVersion topVer, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.id = id;
        this.cacheName = cacheName;
        this.pageSize = pageSize;
        this.incBackups = incBackups;
        this.fields = fields;
        this.all = all;
        this.keepBinary = keepBinary;
        this.subjId = subjId;
        this.taskHash = taskHash;
        this.topVer = topVer;
        this.addDepInfo = addDepInfo;
    }

    public GridCacheQueryRequest(int cacheId, long id, String cacheName, GridCacheQueryType type, boolean fields, String clause, String clsName, IgniteBiPredicate<Object, Object> keyValFilter, @Nullable Integer part, IgniteReducer<Object, Object> rdc, IgniteClosure<?, ?> trans, int pageSize, boolean incBackups, Object[] args, boolean incMeta, boolean keepBinary, UUID subjId, int taskHash, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, boolean addDepInfo) {
        assert (type != null || fields);
        assert (clause != null || type == GridCacheQueryType.SCAN || type == GridCacheQueryType.SET || type == GridCacheQueryType.SPI);
        assert (clsName != null || fields || type == GridCacheQueryType.SCAN || type == GridCacheQueryType.SET || type == GridCacheQueryType.SPI);
        this.cacheId = cacheId;
        this.id = id;
        this.cacheName = cacheName;
        this.type = type;
        this.fields = fields;
        this.clause = clause;
        this.clsName = clsName;
        this.keyValFilter = keyValFilter;
        this.part = part == null ? -1 : part;
        this.rdc = rdc;
        this.trans = trans;
        this.pageSize = pageSize;
        this.incBackups = incBackups;
        this.args = args;
        this.incMeta = incMeta;
        this.keepBinary = keepBinary;
        this.subjId = subjId;
        this.taskHash = taskHash;
        this.topVer = topVer;
        this.mvccSnapshot = mvccSnapshot;
        this.addDepInfo = addDepInfo;
    }

    @Nullable
    MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer != null ? this.topVer : AffinityTopologyVersion.NONE;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.keyValFilter != null && this.keyValFilterBytes == null) {
            if (this.addDepInfo) {
                this.prepareObject(this.keyValFilter, cctx);
            }
            this.keyValFilterBytes = CU.marshal(cctx, this.keyValFilter);
        }
        if (this.rdc != null && this.rdcBytes == null) {
            if (this.addDepInfo) {
                this.prepareObject(this.rdc, cctx);
            }
            this.rdcBytes = CU.marshal(cctx, this.rdc);
        }
        if (this.trans != null && this.transBytes == null) {
            if (this.addDepInfo) {
                this.prepareObject(this.trans, cctx);
            }
            this.transBytes = CU.marshal(cctx, this.trans);
        }
        if (!F.isEmpty(this.args) && this.argsBytes == null) {
            if (this.addDepInfo) {
                for (Object arg : this.args) {
                    this.prepareObject(arg, cctx);
                }
            }
            this.argsBytes = CU.marshal(cctx, this.args);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        Marshaller mrsh = ctx.marshaller();
        if (this.keyValFilterBytes != null && this.keyValFilter == null) {
            this.keyValFilter = (IgniteBiPredicate)U.unmarshal(mrsh, this.keyValFilterBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.rdcBytes != null && this.rdc == null) {
            this.rdc = (IgniteReducer)U.unmarshal(mrsh, this.rdcBytes, ldr);
        }
        if (this.transBytes != null && this.trans == null) {
            this.trans = (IgniteClosure)U.unmarshal(mrsh, this.transBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.argsBytes != null && this.args == null) {
            this.args = (Object[])U.unmarshal(mrsh, this.argsBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    void beforeLocalExecution(GridCacheContext ctx) throws IgniteCheckedException {
        Marshaller marsh = ctx.marshaller();
        this.rdc = this.rdc != null ? (IgniteReducer)U.unmarshal(marsh, U.marshal(marsh, this.rdc), U.resolveClassLoader(ctx.gridConfig())) : null;
        this.trans = this.trans != null ? (IgniteClosure)U.unmarshal(marsh, U.marshal(marsh, this.trans), U.resolveClassLoader(ctx.gridConfig())) : null;
    }

    public long id() {
        return this.id;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public GridCacheQueryType type() {
        return this.type;
    }

    public boolean fields() {
        return this.fields;
    }

    public String clause() {
        return this.clause;
    }

    public String className() {
        return this.clsName;
    }

    public boolean includeBackups() {
        return this.incBackups;
    }

    public boolean cancel() {
        return this.cancel;
    }

    public IgniteBiPredicate<Object, Object> keyValueFilter() {
        return this.keyValFilter;
    }

    public IgniteReducer<Object, Object> reducer() {
        return this.rdc;
    }

    public IgniteClosure<?, ?> transformer() {
        return this.trans;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public Object[] arguments() {
        return this.args;
    }

    public boolean includeMetaData() {
        return this.incMeta;
    }

    public boolean allPages() {
        return this.all;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskHash() {
        return this.taskHash;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeBoolean("all", this.all)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("argsBytes", this.argsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeString("cacheName", this.cacheName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeBoolean("cancel", this.cancel)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeString("clause", this.clause)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeString("clsName", this.clsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeBoolean("fields", this.fields)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeLong("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeBoolean("incBackups", this.incBackups)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("incMeta", this.incMeta)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeBoolean("keepBinary", this.keepBinary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeByteArray("keyValFilterBytes", this.keyValFilterBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeByteArray("rdcBytes", this.rdcBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeInt("taskHash", this.taskHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeByteArray("transBytes", this.transBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeByte("type", this.type != null ? (byte)this.type.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.all = reader.readBoolean("all");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.argsBytes = reader.readByteArray("argsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.cacheName = reader.readString("cacheName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.cancel = reader.readBoolean("cancel");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.clause = reader.readString("clause");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.clsName = reader.readString("clsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.fields = reader.readBoolean("fields");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.id = reader.readLong("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.incBackups = reader.readBoolean("incBackups");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.incMeta = reader.readBoolean("incMeta");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.keepBinary = reader.readBoolean("keepBinary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.keyValFilterBytes = reader.readByteArray("keyValFilterBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.rdcBytes = reader.readByteArray("rdcBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.taskHash = reader.readInt("taskHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.transBytes = reader.readByteArray("transBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                byte typeOrd = reader.readByte("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.type = GridCacheQueryType.fromOrdinal(typeOrd);
                reader.incrementState();
            }
            case 23: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheQueryRequest.class);
    }

    @Override
    public short directType() {
        return 58;
    }

    @Override
    public byte fieldsCount() {
        return 24;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheQueryRequest.class, this, super.toString());
    }
}

