/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionMetrics;
import org.apache.ignite.transactions.TransactionState;

public class TransactionMetricsAdapter
implements TransactionMetrics,
Externalizable {
    private final GridKernalContext gridKernalCtx;
    private static final long serialVersionUID = 0L;
    private volatile int txCommits;
    private volatile int txRollbacks;
    private volatile long commitTime;
    private volatile long rollbackTime;

    public TransactionMetricsAdapter() {
        this(null);
    }

    public TransactionMetricsAdapter(GridKernalContext ctx) {
        this.gridKernalCtx = ctx;
    }

    @Override
    public long commitTime() {
        return this.commitTime;
    }

    @Override
    public long rollbackTime() {
        return this.rollbackTime;
    }

    @Override
    public int txCommits() {
        return this.txCommits;
    }

    @Override
    public int txRollbacks() {
        return this.txRollbacks;
    }

    @Override
    public Map<String, String> getAllOwnerTransactions() {
        return this.getNearTxs(0L);
    }

    @Override
    public Map<String, String> getLongRunningOwnerTransactions(int duration) {
        return this.getNearTxs(duration);
    }

    @Override
    public long getTransactionsCommittedNumber() {
        return this.gridKernalCtx.cache().context().txMetrics().txCommits();
    }

    @Override
    public long getTransactionsRolledBackNumber() {
        return this.gridKernalCtx.cache().context().txMetrics().txRollbacks();
    }

    @Override
    public long getTransactionsHoldingLockNumber() {
        return this.txHoldingLockNum();
    }

    @Override
    public long getLockedKeysNumber() {
        return this.txLockedKeysNum();
    }

    @Override
    public long getOwnerTransactionsNumber() {
        return this.nearTxNum();
    }

    public void onTxCommit() {
        this.commitTime = U.currentTimeMillis();
        ++this.txCommits;
    }

    public void onTxRollback() {
        this.rollbackTime = U.currentTimeMillis();
        ++this.txRollbacks;
    }

    public void reset() {
        this.commitTime = 0L;
        this.txCommits = 0;
        this.rollbackTime = 0L;
        this.txRollbacks = 0;
    }

    private Map<String, String> getNearTxs(long duration) {
        Collection<GridNearTxLocal> txs = this.nearTxs(duration);
        HashMap<String, String> res = new HashMap<String, String>(txs.size());
        for (GridNearTxLocal tx : txs) {
            res.put(tx.xid().toString(), this.composeTx(tx));
        }
        return res;
    }

    private String composeNodeInfo(UUID id) {
        ClusterNode node = this.gridKernalCtx.discovery().node(id);
        if (node == null) {
            return "";
        }
        return String.format("%s %s", node.id(), node.hostNames());
    }

    private String composeNodeInfo(Set<UUID> ids) {
        GridStringBuilder sb = new GridStringBuilder();
        sb.a("[");
        String delim = "";
        for (UUID id : ids) {
            sb.a(delim).a(this.composeNodeInfo(id));
            delim = ", ";
        }
        sb.a("]");
        return sb.toString();
    }

    private String composeTx(GridNearTxLocal tx) {
        Set<UUID> primaryNodes;
        Map<UUID, Collection<UUID>> transactionNodes;
        TransactionState txState = tx.state();
        String top = (Object)((Object)txState) + ", NEAR, ";
        if (txState == TransactionState.PREPARING && !F.isEmpty(transactionNodes = tx.transactionNodes()) && !F.isEmpty(primaryNodes = transactionNodes.keySet())) {
            top = top + "PRIMARY: " + this.composeNodeInfo(primaryNodes) + ", ";
        }
        Long duration = System.currentTimeMillis() - tx.startTime();
        return top + "DURATION: " + duration;
    }

    private Collection<GridNearTxLocal> nearTxs(final long duration) {
        final long start = System.currentTimeMillis();
        IgniteClosure<IgniteInternalTx, GridNearTxLocal> c = new IgniteClosure<IgniteInternalTx, GridNearTxLocal>(){

            @Override
            public GridNearTxLocal apply(IgniteInternalTx tx) {
                return (GridNearTxLocal)tx;
            }
        };
        IgnitePredicate<IgniteInternalTx> pred = new IgnitePredicate<IgniteInternalTx>(){

            @Override
            public boolean apply(IgniteInternalTx tx) {
                return tx.local() && tx.near() && start - tx.startTime() >= duration;
            }
        };
        return F.viewReadOnly(this.gridKernalCtx.cache().context().tm().activeTransactions(), c, pred);
    }

    private long nearTxNum() {
        IgnitePredicate<IgniteInternalTx> pred = new IgnitePredicate<IgniteInternalTx>(){

            @Override
            public boolean apply(IgniteInternalTx tx) {
                return tx.local() && tx.near();
            }
        };
        return F.size(this.gridKernalCtx.cache().context().tm().activeTransactions(), pred);
    }

    private long txHoldingLockNum() {
        long holdingLockCounter = 0L;
        IgniteTxManager tm = this.gridKernalCtx.cache().context().tm();
        for (IgniteInternalTx tx : tm.activeTransactions()) {
            if (tx.optimistic() && tx.state() == TransactionState.ACTIVE || tx.empty() || !tx.local()) continue;
            ++holdingLockCounter;
        }
        return holdingLockCounter;
    }

    private long txLockedKeysNum() {
        GridCacheMvccManager mvccManager = this.gridKernalCtx.cache().context().mvcc();
        return mvccManager.lockedKeys().size() + mvccManager.nearLockedKeys().size();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.commitTime);
        out.writeLong(this.rollbackTime);
        out.writeInt(this.txCommits);
        out.writeInt(this.txRollbacks);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.commitTime = in.readLong();
        this.rollbackTime = in.readLong();
        this.txCommits = in.readInt();
        this.txRollbacks = in.readInt();
    }

    public String toString() {
        return S.toString(TransactionMetricsAdapter.class, this);
    }
}

