/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionImpl;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MvccDataRow
extends DataRow {
    @GridToStringInclude
    private long mvccCrd;
    @GridToStringInclude
    private long mvccCntr;
    @GridToStringInclude
    private int mvccOpCntr;
    @GridToStringInclude
    private byte mvccTxState;
    @GridToStringInclude
    private long newMvccCrd;
    @GridToStringInclude
    private long newMvccCntr;
    @GridToStringInclude
    private int newMvccOpCntr;
    @GridToStringInclude
    private byte newMvccTxState;

    public MvccDataRow(long link) {
        super(link);
    }

    public MvccDataRow(CacheGroupContext grp, int hash, long link, int part, CacheDataRowAdapter.RowData rowData, long crdVer, long mvccCntr, int mvccOpCntr) {
        super(grp, hash, link, part, rowData);
        assert (MvccUtils.mvccVersionIsValid(crdVer, mvccCntr, mvccOpCntr));
        assert (rowData == CacheDataRowAdapter.RowData.LINK_ONLY || this.mvccCoordinatorVersion() == crdVer && this.mvccCounter() == mvccCntr && this.mvccOperationCounter() == mvccOpCntr) : "mvccVer=" + new MvccVersionImpl(crdVer, mvccCntr, mvccOpCntr) + ", dataMvccVer=" + new MvccVersionImpl(this.mvccCoordinatorVersion(), this.mvccCounter(), this.mvccOperationCounter());
        if (rowData == CacheDataRowAdapter.RowData.LINK_ONLY) {
            this.mvccCrd = crdVer;
            this.mvccCntr = mvccCntr;
            this.mvccOpCntr = mvccOpCntr;
        }
    }

    public MvccDataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, int cacheId, MvccVersion mvccVer, MvccVersion newMvccVer) {
        super(key, val, ver, part, expireTime, cacheId);
        this.mvccCrd = mvccVer.coordinatorVersion();
        this.mvccCntr = mvccVer.counter();
        this.mvccOpCntr = mvccVer.operationCounter();
        if (newMvccVer == null) {
            this.newMvccCrd = 0L;
            this.newMvccCntr = 0L;
            this.newMvccOpCntr = 0;
        } else {
            this.newMvccCrd = newMvccVer.coordinatorVersion();
            this.newMvccCntr = newMvccVer.counter();
            this.newMvccOpCntr = newMvccVer.operationCounter();
        }
    }

    @Override
    protected int readHeader(long addr, int off) {
        this.mvccCrd = PageUtils.getLong(addr, off);
        this.mvccCntr = PageUtils.getLong(addr, off + 8);
        int withHint = PageUtils.getInt(addr, off + 16);
        this.mvccOpCntr = withHint & 0x3FFFFFFF;
        this.mvccTxState = (byte)(withHint >>> 30);
        assert (MvccUtils.mvccVersionIsValid(this.mvccCrd, this.mvccCntr, this.mvccOpCntr));
        this.newMvccCrd = PageUtils.getLong(addr, off + 20);
        this.newMvccCntr = PageUtils.getLong(addr, off + 28);
        withHint = PageUtils.getInt(addr, off + 36);
        this.newMvccOpCntr = withHint & 0x3FFFFFFF;
        this.newMvccTxState = (byte)(withHint >>> 30);
        assert (this.newMvccCrd == 0L || MvccUtils.mvccVersionIsValid(this.newMvccCrd, this.newMvccCntr, this.newMvccOpCntr));
        return 40;
    }

    @Override
    public long mvccCoordinatorVersion() {
        return this.mvccCrd;
    }

    @Override
    public long mvccCounter() {
        return this.mvccCntr;
    }

    @Override
    public int mvccOperationCounter() {
        return this.mvccOpCntr & 0xDFFFFFFF;
    }

    @Override
    public byte mvccTxState() {
        return this.mvccTxState;
    }

    @Override
    public long newMvccCoordinatorVersion() {
        return this.newMvccCrd;
    }

    @Override
    public long newMvccCounter() {
        return this.newMvccCntr;
    }

    @Override
    public int newMvccOperationCounter() {
        return this.newMvccOpCntr & 0xDFFFFFFF;
    }

    @Override
    public byte newMvccTxState() {
        return this.newMvccTxState;
    }

    @Override
    public void newMvccVersion(long crd, long cntr, int opCntr) {
        this.newMvccCrd = crd;
        this.newMvccCntr = cntr;
        this.newMvccOpCntr = opCntr;
        this.newMvccTxState = 0;
    }

    @Override
    public void mvccVersion(long crd, long cntr, int opCntr) {
        this.mvccCrd = crd;
        this.mvccCntr = cntr;
        this.mvccOpCntr = opCntr;
        this.mvccTxState = 0;
    }

    public void mvccTxState(byte mvccTxState) {
        this.mvccTxState = mvccTxState;
    }

    public void newMvccTxState(byte newMvccTxState) {
        this.newMvccTxState = newMvccTxState;
    }

    protected boolean keyAbsentBeforeFlag() {
        long withHint = this.newMvccCrd == 0L ? (long)this.mvccOpCntr : (long)this.newMvccOpCntr;
        return (withHint & 0x20000000L) >>> 29 == 1L;
    }

    protected void keyAbsentBeforeFlag(boolean flag) {
        if (flag) {
            if (this.mvccCrd != 0L) {
                this.mvccOpCntr |= 0x20000000;
            }
            if (this.newMvccCrd != 0L) {
                this.newMvccOpCntr |= 0x20000000;
            }
        } else {
            this.mvccOpCntr &= 0xDFFFFFFF;
            this.newMvccOpCntr &= 0xDFFFFFFF;
        }
    }

    @Override
    public int size() throws IgniteCheckedException {
        return super.size() + 40;
    }

    @Override
    public int headerSize() {
        return 40;
    }

    @Override
    public String toString() {
        return S.toString(MvccDataRow.class, this, "super", super.toString());
    }
}

