/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class IdleVerifyResultV2
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> cntrConflicts;
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts;
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions;

    public IdleVerifyResultV2(Map<PartitionKeyV2, List<PartitionHashRecordV2>> cntrConflicts, Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts, Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions) {
        this.cntrConflicts = cntrConflicts;
        this.hashConflicts = hashConflicts;
        this.movingPartitions = movingPartitions;
    }

    public IdleVerifyResultV2() {
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.cntrConflicts);
        U.writeMap(out, this.hashConflicts);
        U.writeMap(out, this.movingPartitions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cntrConflicts = U.readMap(in);
        this.hashConflicts = U.readMap(in);
        this.movingPartitions = U.readMap(in);
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> counterConflicts() {
        return this.cntrConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts() {
        return this.hashConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions() {
        return this.movingPartitions;
    }

    public boolean hasConflicts() {
        return !F.isEmpty(this.hashConflicts()) || !F.isEmpty(this.counterConflicts());
    }

    public void print(Consumer<String> printer) {
        if (!this.hasConflicts()) {
            printer.accept("idle_verify check has finished, no conflicts have been found.\n");
        } else {
            int cntrConflictsSize = this.counterConflicts().size();
            int hashConflictsSize = this.hashConflicts().size();
            printer.accept("idle_verify check has finished, found " + (cntrConflictsSize + hashConflictsSize) + " conflict partitions: [counterConflicts=" + cntrConflictsSize + ", hashConflicts=" + hashConflictsSize + "]\n");
            if (!F.isEmpty(this.counterConflicts())) {
                printer.accept("Update counter conflicts:\n");
                for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : this.counterConflicts().entrySet()) {
                    printer.accept("Conflict partition: " + entry.getKey() + "\n");
                    printer.accept("Partition instances: " + entry.getValue() + "\n");
                }
                printer.accept("\n");
            }
            if (!F.isEmpty(this.hashConflicts())) {
                printer.accept("Hash conflicts:\n");
                for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : this.hashConflicts().entrySet()) {
                    printer.accept("Conflict partition: " + entry.getKey() + "\n");
                    printer.accept("Partition instances: " + entry.getValue() + "\n");
                }
                printer.accept("\n");
            }
        }
        if (!F.isEmpty(this.movingPartitions())) {
            printer.accept("Verification was skipped for " + this.movingPartitions().size() + " MOVING partitions:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : this.movingPartitions().entrySet()) {
                printer.accept("Rebalancing partition: " + entry.getKey() + "\n");
                printer.accept("Partition instances: " + entry.getValue() + "\n");
            }
            printer.accept("\n");
        }
    }

    public String toString() {
        return S.toString(IdleVerifyResultV2.class, this);
    }
}

