/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsAttributes
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String igfsName;
    private int blockSize;
    private int grpSize;
    private String metaCacheName;
    private String dataCacheName;
    private IgfsMode dfltMode;
    private boolean fragmentizerEnabled;
    private Map<String, IgfsMode> pathModes;

    public IgfsAttributes(String igfsName, int blockSize, int grpSize, String metaCacheName, String dataCacheName, IgfsMode dfltMode, Map<String, IgfsMode> pathModes, boolean fragmentizerEnabled) {
        this.blockSize = blockSize;
        this.igfsName = igfsName;
        this.grpSize = grpSize;
        this.metaCacheName = metaCacheName;
        this.dataCacheName = dataCacheName;
        this.dfltMode = dfltMode;
        this.pathModes = pathModes;
        this.fragmentizerEnabled = fragmentizerEnabled;
    }

    public IgfsAttributes() {
    }

    public String igfsName() {
        return this.igfsName;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public int groupSize() {
        return this.grpSize;
    }

    public String metaCacheName() {
        return this.metaCacheName;
    }

    public String dataCacheName() {
        return this.dataCacheName;
    }

    public IgfsMode defaultMode() {
        return this.dfltMode;
    }

    public Map<String, IgfsMode> pathModes() {
        return this.pathModes != null ? Collections.unmodifiableMap(this.pathModes) : null;
    }

    public boolean fragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igfsName);
        out.writeInt(this.blockSize);
        out.writeInt(this.grpSize);
        U.writeString(out, this.metaCacheName);
        U.writeString(out, this.dataCacheName);
        U.writeEnum(out, this.dfltMode);
        out.writeBoolean(this.fragmentizerEnabled);
        if (this.pathModes != null) {
            out.writeBoolean(true);
            out.writeInt(this.pathModes.size());
            for (Map.Entry<String, IgfsMode> pathMode : this.pathModes.entrySet()) {
                U.writeString(out, pathMode.getKey());
                U.writeEnum(out, (Enum)pathMode.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igfsName = U.readString(in);
        this.blockSize = in.readInt();
        this.grpSize = in.readInt();
        this.metaCacheName = U.readString(in);
        this.dataCacheName = U.readString(in);
        this.dfltMode = IgfsMode.fromOrdinal(in.readByte());
        this.fragmentizerEnabled = in.readBoolean();
        if (in.readBoolean()) {
            int size = in.readInt();
            this.pathModes = new HashMap<String, IgfsMode>(size, 1.0f);
            for (int i = 0; i < size; ++i) {
                this.pathModes.put(U.readString(in), IgfsMode.fromOrdinal(in.readByte()));
            }
        }
    }
}

