/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client.meta;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsClientMetaUnlockCallable
extends IgfsClientAbstractCallable<Void> {
    private static final long serialVersionUID = 0L;
    private IgniteUuid fileId;
    private IgniteUuid lockId;
    private long modificationTime;
    private boolean updateSpace;
    private long space;
    private IgfsFileAffinityRange affRange;

    public IgfsClientMetaUnlockCallable() {
    }

    public IgfsClientMetaUnlockCallable(@Nullable String igfsName, @Nullable String user, IgniteUuid fileId, IgniteUuid lockId, long modificationTime, boolean updateSpace, long space, IgfsFileAffinityRange affRange) {
        super(igfsName, user, null);
        this.fileId = fileId;
        this.lockId = lockId;
        this.modificationTime = modificationTime;
        this.updateSpace = updateSpace;
        this.space = space;
        this.affRange = affRange;
    }

    @Override
    protected Void call0(IgfsContext ctx) throws Exception {
        ctx.meta().unlock(this.fileId, this.lockId, this.modificationTime, this.updateSpace, this.space, this.affRange);
        return null;
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        BinaryUtils.writeIgniteUuid(writer, this.fileId);
        BinaryUtils.writeIgniteUuid(writer, this.lockId);
        writer.writeLong(this.modificationTime);
        writer.writeBoolean(this.updateSpace);
        if (this.updateSpace) {
            writer.writeLong(this.space);
        }
        IgfsUtils.writeFileAffinityRange(writer, this.affRange);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.fileId = BinaryUtils.readIgniteUuid(reader);
        this.lockId = BinaryUtils.readIgniteUuid(reader);
        this.modificationTime = reader.readLong();
        this.updateSpace = reader.readBoolean();
        if (this.updateSpace) {
            this.space = reader.readLong();
        }
        this.affRange = IgfsUtils.readFileAffinityRange(reader);
    }

    public String toString() {
        return S.toString(IgfsClientMetaUnlockCallable.class, this);
    }
}

