/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaDirectoryListingRemoveProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String fileName;
    private IgniteUuid fileId;

    public IgfsMetaDirectoryListingRemoveProcessor() {
    }

    public IgfsMetaDirectoryListingRemoveProcessor(String fileName, IgniteUuid fileId) {
        this.fileName = fileName;
        this.fileId = fileId;
    }

    @Override
    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> e, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo fileInfo = (IgfsEntryInfo)e.getValue();
        assert (fileInfo != null);
        assert (fileInfo.isDirectory());
        HashMap<String, IgfsListingEntry> listing = new HashMap<String, IgfsListingEntry>(fileInfo.listing());
        IgfsListingEntry oldEntry = (IgfsListingEntry)listing.get(this.fileName);
        if (oldEntry == null || !oldEntry.fileId().equals(this.fileId)) {
            throw new IgniteException("Directory listing doesn't contain expected file [listing=" + listing + ", fileName=" + this.fileName + "]");
        }
        listing.remove(this.fileName);
        e.setValue(fileInfo.listing(listing));
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.fileName);
        U.writeGridUuid(out, this.fileId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fileName = U.readString(in);
        this.fileId = U.readGridUuid(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeString(this.fileName);
        BinaryUtils.writeIgniteUuid(out, this.fileId);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.fileName = in.readString();
        this.fileId = BinaryUtils.readIgniteUuid(in);
    }

    public String toString() {
        return S.toString(IgfsMetaDirectoryListingRemoveProcessor.class, this);
    }
}

