/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

@ComputeTaskNoResultCache
public class PlatformBroadcastingSingleClosureTask
extends PlatformAbstractTask {
    private static final long serialVersionUID = 0L;
    private PlatformJob job;

    public PlatformBroadcastingSingleClosureTask(PlatformContext ctx, long taskPtr) {
        super(ctx, taskPtr);
    }

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) {
        assert (this.job != null) : "Job null-check must be performed in native platform.";
        if (!F.isEmpty(subgrid)) {
            HashMap<PlatformJob, ClusterNode> map = new HashMap<PlatformJob, ClusterNode>(subgrid.size(), 1.0f);
            boolean first = true;
            for (ClusterNode node : subgrid) {
                if (first) {
                    map.put(this.job, node);
                    first = false;
                    continue;
                }
                map.put(this.ctx.createClosureJob(this, this.job.pointer(), this.job.job()), node);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public void job(PlatformJob job) {
        this.job = job;
    }
}

