/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryClientEndpoint;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.nio.GridAbstractCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioMetricsListener;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;

public class GridShmemCommunicationClient
extends GridAbstractCommunicationClient {
    private final IpcSharedMemoryClientEndpoint shmem;
    private final ByteBuffer writeBuf;
    private final MessageFormatter formatter;

    public GridShmemCommunicationClient(int connIdx, GridNioMetricsListener metricsLsnr, int port, long connTimeout, IgniteLogger log, MessageFormatter formatter) throws IgniteCheckedException {
        super(connIdx, metricsLsnr);
        assert (metricsLsnr != null);
        assert (port > 0 && port < 65535);
        assert (connTimeout >= 0L);
        this.shmem = new IpcSharedMemoryClientEndpoint(port, (int)connTimeout, log);
        this.writeBuf = ByteBuffer.allocate(8192);
        this.writeBuf.order(ByteOrder.nativeOrder());
        this.formatter = formatter;
    }

    @Override
    public synchronized void doHandshake(IgniteInClosure2X<InputStream, OutputStream> handshakeC) throws IgniteCheckedException {
        handshakeC.applyx(this.shmem.inputStream(), this.shmem.outputStream());
    }

    @Override
    public boolean close() {
        boolean res = super.close();
        if (res) {
            this.shmem.close();
        }
        return res;
    }

    @Override
    public void forceClose() {
        super.forceClose();
        this.shmem.close();
    }

    @Override
    public synchronized void sendMessage(byte[] data, int len) throws IgniteCheckedException {
        if (this.closed()) {
            throw new IgniteCheckedException("Communication client was closed: " + this);
        }
        try {
            this.shmem.outputStream().write(data, 0, len);
            this.metricsLsnr.onBytesSent(len);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send message to remote node: " + this.shmem, e);
        }
        this.markUsed();
    }

    @Override
    public synchronized boolean sendMessage(UUID nodeId, Message msg, IgniteInClosure<IgniteException> c) throws IgniteCheckedException {
        assert (nodeId != null);
        if (this.closed()) {
            throw new IgniteCheckedException("Communication client was closed: " + this);
        }
        assert (this.writeBuf.hasArray());
        try {
            int cnt = U.writeMessageFully(msg, this.shmem.outputStream(), this.writeBuf, this.formatter.writer(nodeId));
            this.metricsLsnr.onBytesSent(cnt);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to send message to remote node: " + this.shmem, e);
        }
        this.markUsed();
        if (c != null) {
            c.apply(null);
        }
        return false;
    }

    @Override
    public void sendMessage(ByteBuffer data) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return S.toString(GridShmemCommunicationClient.class, this, super.toString());
    }
}

