/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.typedef;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public final class X {
    public static final Object[] EMPTY_OBJECT_ARRAY;
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long SECONDS_IN_MINUTE = 60L;
    private static final long MINUTES_IN_HOUR = 60L;
    private static final long HOURS_IN_DAY = 24L;
    private static final long[] SPAN_DIVS;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final String[] CAUSE_MTD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;

    private X() {
    }

    public static void println() {
        System.out.println();
    }

    public static void printerrln() {
        System.err.println();
    }

    public static void println(@Nullable String s1, Object ... rest) {
        System.out.println(s1);
        if (rest != null && rest.length > 0) {
            for (Object obj : rest) {
                System.out.println(obj);
            }
        }
    }

    public static void printerrln(@Nullable String s1, Object ... rest) {
        X.error(s1, rest);
    }

    public static void error(@Nullable String s1, Object ... rest) {
        System.err.println(s1);
        if (rest != null && rest.length > 0) {
            for (Object obj : rest) {
                System.err.println(obj);
            }
        }
    }

    public static void print(@Nullable String s1, Object ... rest) {
        System.out.print(s1);
        if (rest != null && rest.length > 0) {
            for (Object obj : rest) {
                System.out.print(obj);
            }
        }
    }

    public static void printerr(@Nullable String s1, Object ... rest) {
        System.err.print(s1);
        if (rest != null && rest.length > 0) {
            for (Object obj : rest) {
                System.err.print(obj);
            }
        }
    }

    @Nullable
    public static String getSystemOrEnv(String name) {
        assert (name != null);
        String v = System.getProperty(name);
        if (v == null) {
            v = System.getenv(name);
        }
        return v;
    }

    public static String timeSpan2HMSM(long span) {
        long[] t = new long[4];
        int i = 0;
        for (long sp = span; i < SPAN_DIVS.length && sp > 0L; sp /= SPAN_DIVS[i++]) {
            t[i] = sp % SPAN_DIVS[i];
        }
        return (t[3] < 10L ? "0" + t[3] : Long.toString(t[3])) + ':' + (t[2] < 10L ? "0" + t[2] : Long.toString(t[2])) + ':' + (t[1] < 10L ? "0" + t[1] : Long.toString(t[1])) + '.' + (t[0] < 10L ? "00" + t[0] : (t[0] < 100L ? "0" + t[0] : Long.toString(t[0])));
    }

    public static String timeSpan2HMS(long span) {
        long[] t = new long[4];
        int i = 0;
        for (long sp = span; i < SPAN_DIVS.length && sp > 0L; sp /= SPAN_DIVS[i++]) {
            t[i] = sp % SPAN_DIVS[i];
        }
        return (t[3] < 10L ? "0" + t[3] : Long.toString(t[3])) + ':' + (t[2] < 10L ? "0" + t[2] : Long.toString(t[2])) + ':' + (t[1] < 10L ? "0" + t[1] : Long.toString(t[1]));
    }

    public static String timeSpan2DHMSM(long span) {
        String days = "";
        String hmsm = X.timeSpan2HMSM(span % 86400000L);
        long daysCnt = span / 86400000L;
        if (daysCnt == 1L) {
            days = "1 day, ";
        } else if (daysCnt > 1L) {
            days = daysCnt + " days, ";
        }
        return days + hmsm;
    }

    @Nullable
    public static <T> T cloneObject(@Nullable T obj, boolean deep, boolean honorCloneable) {
        if (obj == null) {
            return null;
        }
        try {
            return (T)(!deep ? X.shallowClone(obj) : X.deepClone(new GridLeanMap<Integer, Integer>(), new ArrayList<Object>(), obj, honorCloneable));
        }
        catch (Exception e) {
            throw new IgniteException("Unable to clone instance of class: " + obj.getClass(), e);
        }
    }

    @Nullable
    private static <T> T shallowClone(@Nullable T obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Cloneable)) {
            return obj;
        }
        if (obj.getClass().isArray()) {
            return (T)(obj instanceof byte[] ? ((byte[])obj).clone() : (obj instanceof short[] ? ((short[])obj).clone() : (obj instanceof char[] ? ((char[])obj).clone() : (obj instanceof int[] ? ((int[])obj).clone() : (obj instanceof long[] ? ((long[])obj).clone() : (obj instanceof float[] ? ((float[])obj).clone() : (obj instanceof double[] ? ((double[])obj).clone() : (obj instanceof boolean[] ? ((boolean[])obj).clone() : ((Object[])obj).clone()))))))));
        }
        try {
            Method mtd = obj.getClass().getDeclaredMethod("clone", new Class[0]);
            boolean set = false;
            if (!mtd.isAccessible()) {
                set = true;
                mtd.setAccessible(true);
            }
            Object clone = mtd.invoke(obj, new Object[0]);
            if (set) {
                mtd.setAccessible(false);
            }
            return (T)clone;
        }
        catch (Exception e) {
            throw new IgniteException("Unable to clone instance of class: " + obj.getClass(), e);
        }
    }

    @Nullable
    private static Object deepClone(Map<Integer, Integer> identityIdxs, List<Object> clones, @Nullable Object obj, boolean honorCloneable) throws Exception {
        if (obj == null) {
            return null;
        }
        if (honorCloneable && obj instanceof Cloneable) {
            return X.shallowClone(obj);
        }
        Integer idx = identityIdxs.get(System.identityHashCode(obj));
        Object clone = null;
        if (idx != null) {
            clone = clones.get(idx);
        }
        if (clone != null) {
            return clone;
        }
        if (obj instanceof Class) {
            return obj;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            Class<?> arrType = cls.getComponentType();
            int len = Array.getLength(obj);
            clone = Array.newInstance(arrType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(clone, i, X.deepClone(identityIdxs, clones, Array.get(obj, i), honorCloneable));
            }
            clones.add(clone);
            identityIdxs.put(System.identityHashCode(obj), clones.size() - 1);
            return clone;
        }
        clone = U.forceNewInstance(cls);
        if (clone == null) {
            throw new IgniteException("Failed to clone object (empty constructor could not be assigned): " + obj);
        }
        clones.add(clone);
        identityIdxs.put(System.identityHashCode(obj), clones.size() - 1);
        for (Class<?> c = cls; c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                X.cloneField(identityIdxs, clones, obj, clone, f, honorCloneable);
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cloneField(Map<Integer, Integer> identityIdxs, List<Object> clones, Object obj, Object clone, Field f, boolean honorCloneable) throws Exception {
        int modifiers = f.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return;
        }
        boolean set = false;
        if (!f.isAccessible()) {
            f.setAccessible(true);
            set = true;
        }
        try {
            if (f.getType().isPrimitive()) {
                f.set(clone, f.get(obj));
            } else {
                f.set(clone, X.deepClone(identityIdxs, clones, f.get(obj), honorCloneable));
            }
        }
        finally {
            if (set) {
                f.setAccessible(false);
            }
        }
    }

    @SafeVarargs
    public static boolean hasCause(@Nullable Throwable t, Class<?> ... cls) {
        if (t == null || F.isEmpty(cls)) {
            return false;
        }
        assert (cls != null);
        for (Throwable th = t; th != null; th = th.getCause()) {
            for (Class<?> clazz : cls) {
                if (!clazz.isAssignableFrom(th.getClass())) continue;
                return true;
            }
            for (Serializable serializable : th.getSuppressed()) {
                if (!X.hasCause((Throwable)serializable, cls)) continue;
                return true;
            }
            if (th.getCause() == th) break;
        }
        return false;
    }

    public static boolean hasSuppressed(@Nullable Throwable t, @Nullable Class<? extends Throwable> cls) {
        if (t == null || cls == null) {
            return false;
        }
        for (Throwable th : t.getSuppressed()) {
            if (cls.isAssignableFrom(th.getClass())) {
                return true;
            }
            if (!X.hasSuppressed(th, cls)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends Throwable> T cause(@Nullable Throwable t, @Nullable Class<T> cls) {
        if (t == null || cls == null) {
            return null;
        }
        for (Throwable th = t; th != null; th = th.getCause()) {
            if (cls.isAssignableFrom(th.getClass())) {
                return (T)th;
            }
            for (Throwable n : th.getSuppressed()) {
                T found = X.cause(n, cls);
                if (found == null) continue;
                return found;
            }
            if (th.getCause() == th) break;
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String mtdName) {
        Method mtd = null;
        try {
            mtd = throwable.getClass().getMethod(mtdName, null);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (mtd != null && Throwable.class.isAssignableFrom(mtd.getReturnType())) {
            try {
                return (Throwable)mtd.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException || throwable instanceof InvocationTargetException) {
            return true;
        }
        if (X.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        for (String CAUSE_MTD_NAME : CAUSE_MTD_NAMES) {
            try {
                Method mtd = cls.getMethod(CAUSE_MTD_NAME, null);
                if (mtd == null || !Throwable.class.isAssignableFrom(mtd.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable) {
        return X.getCause(throwable, CAUSE_MTD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] mtdNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = X.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            if (mtdNames == null) {
                mtdNames = CAUSE_MTD_NAMES;
            }
            for (String mtdName : mtdNames) {
                if (mtdName != null && (cause = X.getCauseUsingMethodName(throwable, mtdName)) != null) break;
            }
            if (cause == null) {
                cause = X.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = X.getCause(throwable);
        }
        return list;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List<Throwable> list = X.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    public static List<Throwable> getSuppressedList(@Nullable Throwable t) {
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        if (t == null) {
            return result;
        }
        do {
            for (Throwable suppressed : t.getSuppressed()) {
                result.add(suppressed);
                result.addAll(X.getSuppressedList(suppressed));
            }
        } while ((t = t.getCause()) != null);
        return result;
    }

    public static String getFullStackTrace(Throwable throwable) {
        Throwable[] ts;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        for (Throwable t : ts = X.getThrowables(throwable)) {
            t.printStackTrace(pw);
            if (X.isNestedThrowable(t)) break;
        }
        return sw.getBuffer().toString();
    }

    public static void waitAll(@Nullable Iterable<IgniteFuture<?>> futs) {
        if (F.isEmpty(futs)) {
            return;
        }
        for (IgniteFuture<?> fut : futs) {
            fut.get();
        }
    }

    public static String formatMins(long mins) {
        long hh;
        assert (mins >= 0L);
        if (mins == 0L) {
            return "< 1 min";
        }
        SB sb = new SB();
        long dd = mins / 1440L;
        if (dd > 0L) {
            sb.a(dd).a(dd == 1L ? " day " : " days ");
        }
        if ((hh = (mins %= 1440L) / 60L) > 0L) {
            sb.a(hh).a(hh == 1L ? " hour " : " hours ");
        }
        if ((mins %= 60L) > 0L) {
            sb.a(mins).a(mins == 1L ? " min " : " mins ");
        }
        return sb.toString().trim();
    }

    public static void checkMinMemory(long min) {
        long maxMem = Runtime.getRuntime().maxMemory();
        if ((double)maxMem < 0.85 * (double)min) {
            X.printerrln("Heap limit is too low (" + maxMem / 0x100000L + "MB), please increase heap size at least up to " + min / 0x100000L + "MB.", new Object[0]);
            System.exit(-1);
        }
    }

    public static int copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        int n;
        byte[] buf = new byte[bufSize];
        int cnt = 0;
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
            cnt += n;
        }
        return cnt;
    }

    public static String resolveIgniteHome() throws IgniteCheckedException {
        String var = IgniteSystemProperties.getString("IGNITE_HOME");
        if (var != null) {
            return var;
        }
        throw new IgniteCheckedException("Failed to resolve Ignite home folder (please set 'IGNITE_HOME' environment or system variable)");
    }

    public static double parseDouble(@Nullable String s, double dflt) {
        try {
            return s != null ? Double.parseDouble(s) : dflt;
        }
        catch (NumberFormatException ignored) {
            return dflt;
        }
    }

    static {
        Method causeMtd;
        EMPTY_OBJECT_ARRAY = new Object[0];
        SPAN_DIVS = new long[]{1000L, 60L, 60L, 24L};
        CAUSE_MTD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMtd = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception ignored) {
            causeMtd = null;
        }
        THROWABLE_CAUSE_METHOD = causeMtd;
    }
}

