/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.mxbean.MXBeanDescription;

@MXBeanDescription(value="MBean that provides access to cache group descriptor.")
public interface CacheGroupMetricsMXBean {
    @MXBeanDescription(value="Cache group id.")
    public int getGroupId();

    @MXBeanDescription(value="Cache group name.")
    public String getGroupName();

    @MXBeanDescription(value="List of caches.")
    public List<String> getCaches();

    @MXBeanDescription(value="Count of backups configured for cache group.")
    public int getBackups();

    @MXBeanDescription(value="Count of partitions for cache group.")
    public int getPartitions();

    @MXBeanDescription(value="Minimum number of partition copies for all partitions of this cache group.")
    public int getMinimumNumberOfPartitionCopies();

    @MXBeanDescription(value="Maximum number of partition copies for all partitions of this cache group.")
    public int getMaximumNumberOfPartitionCopies();

    @MXBeanDescription(value="Count of partitions with state OWNING for this cache group located on this node.")
    public int getLocalNodeOwningPartitionsCount();

    @MXBeanDescription(value="Count of partitions with state MOVING for this cache group located on this node.")
    public int getLocalNodeMovingPartitionsCount();

    @MXBeanDescription(value="Count of partitions with state RENTING for this cache group located on this node.")
    public int getLocalNodeRentingPartitionsCount();

    @MXBeanDescription(value="Count of entries remains to evict in RENTING partitions located on this node for this cache group.")
    public long getLocalNodeRentingEntriesCount();

    @MXBeanDescription(value="Count of partitions for this cache group in the entire cluster with state OWNING.")
    public int getClusterOwningPartitionsCount();

    @MXBeanDescription(value="Count of partitions for this cache group in the entire cluster with state MOVING.")
    public int getClusterMovingPartitionsCount();

    @MXBeanDescription(value="Allocation map of partitions with state OWNING in the cluster.")
    public Map<Integer, Set<String>> getOwningPartitionsAllocationMap();

    @MXBeanDescription(value="Allocation map of partitions with state MOVING in the cluster.")
    public Map<Integer, Set<String>> getMovingPartitionsAllocationMap();

    @MXBeanDescription(value="Affinity partitions assignment map.")
    public Map<Integer, List<String>> getAffinityPartitionsAssignmentMap();

    @MXBeanDescription(value="Cache group type.")
    public String getType();

    @MXBeanDescription(value="Local partition ids.")
    public List<Integer> getPartitionIds();

    @MXBeanDescription(value="Cache group total allocated pages.")
    public long getTotalAllocatedPages();

    @MXBeanDescription(value="Total size of memory allocated for group, in bytes.")
    public long getTotalAllocatedSize();
}

