/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.util.UUID;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;

public class TcpDiscoveryStatusCheckMessage
extends TcpDiscoveryAbstractMessage {
    private static final long serialVersionUID = 0L;
    public static final int STATUS_OK = 1;
    public static final int STATUS_RECON = 2;
    private final TcpDiscoveryNode creatorNode;
    private final UUID failedNodeId;
    private int status;

    public TcpDiscoveryStatusCheckMessage(TcpDiscoveryNode creatorNode, UUID failedNodeId) {
        super(creatorNode.id());
        this.creatorNode = creatorNode;
        this.failedNodeId = failedNodeId;
    }

    public TcpDiscoveryStatusCheckMessage(TcpDiscoveryStatusCheckMessage msg) {
        super(msg);
        this.creatorNode = msg.creatorNode;
        this.failedNodeId = msg.failedNodeId;
        this.status = msg.status;
    }

    public TcpDiscoveryNode creatorNode() {
        return this.creatorNode;
    }

    public UUID failedNodeId() {
        return this.failedNodeId;
    }

    public int status() {
        return this.status;
    }

    public void status(int status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TcpDiscoveryStatusCheckMessage)) {
            return false;
        }
        TcpDiscoveryStatusCheckMessage other = (TcpDiscoveryStatusCheckMessage)obj;
        return F.eqNodes(other.creatorNode, this.creatorNode) && F.eq(other.failedNodeId, this.failedNodeId) && this.status == other.status;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryStatusCheckMessage.class, this, "super", super.toString());
    }
}

