/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.netcrusher.NetFreezer;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.nio.NioUtils;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.state.BitState;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherSocketOptions;
import org.netcrusher.tcp.TcpFilters;
import org.netcrusher.tcp.TcpPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpAcceptor
implements NetFreezer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpAcceptor.class);
    private final InetSocketAddress bindAddress;
    private final InetSocketAddress connectAddress;
    private final InetSocketAddress bindBeforeConnectAddress;
    private final TcpCrusherSocketOptions socketOptions;
    private final NioReactor reactor;
    private final TcpCrusher crusher;
    private final ServerSocketChannel serverSocketChannel;
    private final SelectionKey serverSelectionKey;
    private final BufferOptions bufferOptions;
    private final TcpFilters filters;
    private final State state;
    private final AtomicInteger totalAccepted;

    TcpAcceptor(TcpCrusher crusher, NioReactor reactor, InetSocketAddress bindAddress, InetSocketAddress connectAddress, InetSocketAddress bindBeforeConnectAddress, TcpCrusherSocketOptions socketOptions, TcpFilters filters, BufferOptions bufferOptions) throws IOException {
        this.crusher = crusher;
        this.bindAddress = bindAddress;
        this.connectAddress = connectAddress;
        this.bindBeforeConnectAddress = bindBeforeConnectAddress;
        this.socketOptions = socketOptions;
        this.reactor = reactor;
        this.bufferOptions = bufferOptions;
        this.filters = filters;
        this.totalAccepted = new AtomicInteger(0);
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        if (socketOptions.getBacklog() > 0) {
            this.serverSocketChannel.bind(bindAddress, socketOptions.getBacklog());
        } else {
            this.serverSocketChannel.bind(bindAddress);
        }
        this.serverSelectionKey = reactor.getSelector().register(this.serverSocketChannel, 0, selectionKey -> this.accept());
        this.state = new State(State.FROZEN);
    }

    void close() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                if (this.state.is(State.OPEN)) {
                    this.freeze();
                }
                this.serverSelectionKey.cancel();
                NioUtils.close(this.serverSocketChannel);
                this.reactor.getSelector().wakeup();
                this.state.set(State.CLOSED);
                return true;
            }
            return false;
        });
    }

    private void accept() throws IOException {
        boolean connectedImmediately;
        SocketChannel socketChannel1 = this.serverSocketChannel.accept();
        socketChannel1.configureBlocking(false);
        this.socketOptions.setupSocketChannel(socketChannel1);
        this.bufferOptions.checkTcpSocket(socketChannel1.socket());
        LOGGER.debug("Incoming connection is accepted on <{}>", (Object)this.bindAddress);
        SocketChannel socketChannel2 = SocketChannel.open();
        socketChannel2.configureBlocking(false);
        this.socketOptions.setupSocketChannel(socketChannel2);
        this.bufferOptions.checkTcpSocket(socketChannel2.socket());
        if (this.bindBeforeConnectAddress != null) {
            socketChannel2.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            socketChannel2.bind(this.bindBeforeConnectAddress);
        }
        try {
            connectedImmediately = socketChannel2.connect(this.connectAddress);
        }
        catch (UnresolvedAddressException e) {
            LOGGER.error("Connect address <{}> is unresolved", (Object)this.connectAddress);
            NioUtils.closeNoLinger(socketChannel1);
            NioUtils.closeNoLinger(socketChannel2);
            return;
        }
        catch (UnsupportedAddressTypeException e) {
            LOGGER.error("Connect address <{}> is unsupported", (Object)this.connectAddress);
            NioUtils.closeNoLinger(socketChannel1);
            NioUtils.closeNoLinger(socketChannel2);
            return;
        }
        catch (IOException e) {
            LOGGER.error("IOException on connection", e);
            NioUtils.closeNoLinger(socketChannel1);
            NioUtils.closeNoLinger(socketChannel2);
            return;
        }
        if (connectedImmediately) {
            this.appendPair(socketChannel1, socketChannel2);
        } else {
            this.connectDeferred(socketChannel1, socketChannel2);
        }
    }

    private void connectDeferred(SocketChannel socketChannel1, SocketChannel socketChannel2) throws IOException {
        if (this.socketOptions.getConnectionTimeoutMs() > 0L) {
            this.reactor.getSelector().schedule(() -> {
                if (socketChannel2.isOpen() && !socketChannel2.isConnected()) {
                    LOGGER.error("Fail to connect to <{}> in {}ms", (Object)this.connectAddress, (Object)this.socketOptions.getConnectionTimeoutMs());
                    NioUtils.closeNoLinger(socketChannel1);
                    NioUtils.closeNoLinger(socketChannel2);
                }
            }, TimeUnit.MILLISECONDS.toNanos(this.socketOptions.getConnectionTimeoutMs()));
        }
        this.reactor.getSelector().register(socketChannel2, 8, selectionKey -> {
            boolean connected;
            try {
                connected = socketChannel2.finishConnect();
            }
            catch (IOException e) {
                LOGGER.error("Exception while finishing the connection to <{}>", (Object)this.connectAddress, (Object)e);
                connected = false;
            }
            if (!connected) {
                LOGGER.error("Fail to finish outgoing connection to <{}>", (Object)this.connectAddress);
                NioUtils.closeNoLinger(socketChannel1);
                NioUtils.closeNoLinger(socketChannel2);
                return;
            }
            this.appendPair(socketChannel1, socketChannel2);
        });
    }

    private void appendPair(SocketChannel socketChannel1, SocketChannel socketChannel2) {
        try {
            this.totalAccepted.incrementAndGet();
            InetSocketAddress clientAddress = (InetSocketAddress)socketChannel1.getRemoteAddress();
            Runnable pairShutdown = () -> this.crusher.closeClient(clientAddress);
            TcpPair pair = new TcpPair(this.reactor, this.filters, socketChannel1, socketChannel2, this.bufferOptions, pairShutdown);
            pair.unfreeze();
            this.crusher.notifyPairCreated(pair);
        }
        catch (CancelledKeyException | ClosedChannelException e) {
            LOGGER.debug("One of the channels is already closed", e);
            NioUtils.closeNoLinger(socketChannel1);
            NioUtils.closeNoLinger(socketChannel2);
        }
        catch (IOException e) {
            LOGGER.error("Fail to create TcpCrusher TCP pair", e);
            NioUtils.closeNoLinger(socketChannel1);
            NioUtils.closeNoLinger(socketChannel2);
        }
    }

    int getTotalAccepted() {
        return this.totalAccepted.get();
    }

    @Override
    public void freeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.OPEN)) {
                if (this.serverSelectionKey.isValid()) {
                    this.serverSelectionKey.interestOps(0);
                }
                this.state.set(State.FROZEN);
                LOGGER.debug("TcpCrusher acceptor <{}>-<{}> is frozen", (Object)this.bindAddress, (Object)this.connectAddress);
                return true;
            }
            throw new IllegalStateException("Acceptor is not open on freeze");
        });
    }

    @Override
    public void unfreeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.FROZEN)) {
                this.serverSelectionKey.interestOps(16);
                this.state.set(State.OPEN);
                LOGGER.debug("TcpCrusher acceptor <{}>-<{}> is unfrozen", (Object)this.bindAddress, (Object)this.connectAddress);
                return true;
            }
            throw new IllegalStateException("Acceptor is not frozen on unfreeze");
        });
    }

    @Override
    public boolean isFrozen() {
        return this.state.isAnyOf(State.FROZEN | State.CLOSED);
    }

    private static final class State
    extends BitState {
        private static final int OPEN = State.bit(0);
        private static final int FROZEN = State.bit(1);
        private static final int CLOSED = State.bit(2);

        private State(int state) {
            super(state);
        }
    }
}

