/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public final class PortChooser {
    public static final int MAX = 65535;
    private static final Object VM_WIDE_LOCK = (PortChooser.class.getName() + "LOCK").intern();
    private static final Set<Integer> chosen = new HashSet<Integer>();
    private static final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandomPort() {
        Object object = VM_WIDE_LOCK;
        synchronized (object) {
            int portNum = this.choose();
            chosen.add(portNum);
            return portNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandomPorts(int numOfPorts) {
        int port = 0;
        Object object = VM_WIDE_LOCK;
        synchronized (object) {
            while (true) {
                if ((port = this.choose()) + numOfPorts > 65535) {
                    continue;
                }
                boolean isChosen = true;
                for (int i = 1; i < numOfPorts; ++i) {
                    if (!this.isPortUsed(port + i)) continue;
                    isChosen = false;
                    break;
                }
                if (isChosen && port + numOfPorts <= 65535) break;
            }
            for (int i = 0; i < numOfPorts; ++i) {
                chosen.add(port + i);
            }
        }
        return port;
    }

    public boolean isPortUsed(int portNum) {
        Integer port = portNum;
        if (chosen.contains(port)) {
            return true;
        }
        return !this.canBind(portNum) && !this.canConnect(portNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canConnect(int portNumber) {
        Socket sock = null;
        boolean isFree = false;
        try {
            sock = new Socket("localhost", portNumber);
            isFree = false;
        }
        catch (IOException e) {
            isFree = true;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isFree;
    }

    private boolean canBind(int portNum) {
        if (portNum >= 32768) {
            return false;
        }
        ServerSocket ss = null;
        boolean isFree = false;
        try {
            ss = new ServerSocket(portNum);
            isFree = true;
        }
        catch (BindException be) {
            isFree = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException be) {}
            }
        }
        return isFree;
    }

    private synchronized int choose() {
        int attempt;
        while (chosen.contains(attempt = PortChooser.getNonEphemeralPort()) || !this.canBind(attempt) || !this.canConnect(attempt)) {
        }
        return attempt;
    }

    private static int getNonEphemeralPort() {
        int p;
        while ((p = random.nextInt(64511) + 1024) >= 32768) {
        }
        return p;
    }
}

