/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.ratemetrics.HitRateMetrics;
import org.apache.ignite.internal.processors.cache.store.GridCacheWriteBehindStore;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheMetricsImpl
implements CacheMetrics {
    private static final int REBALANCE_RATE_INTERVAL = IgniteSystemProperties.getInteger("IGNITE_REBALANCE_STATISTICS_TIME_INTERVAL", 60000);
    private static final CachePeekMode[] ONHEAP_PEEK_MODES = new CachePeekMode[]{CachePeekMode.ONHEAP, CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR};
    private static final long NANOS_IN_MICROSECOND = 1000L;
    private AtomicLong reads = new AtomicLong();
    private AtomicLong entryProcessorPuts = new AtomicLong();
    private AtomicLong entryProcessorRemovals = new AtomicLong();
    private AtomicLong entryProcessorReadOnlyInvocations = new AtomicLong();
    private AtomicLong entryProcessorInvokeTimeNanos = new AtomicLong();
    private AtomicLong entryProcessorMinInvocationTime = new AtomicLong();
    private AtomicLong entryProcessorMaxInvocationTime = new AtomicLong();
    private AtomicLong entryProcessorHits = new AtomicLong();
    private AtomicLong entryProcessorMisses = new AtomicLong();
    private AtomicLong writes = new AtomicLong();
    private AtomicLong hits = new AtomicLong();
    private AtomicLong misses = new AtomicLong();
    private AtomicLong txCommits = new AtomicLong();
    private AtomicLong txRollbacks = new AtomicLong();
    private AtomicLong evictCnt = new AtomicLong();
    private AtomicLong rmCnt = new AtomicLong();
    private AtomicLong putTimeNanos = new AtomicLong();
    private AtomicLong getTimeNanos = new AtomicLong();
    private AtomicLong rmvTimeNanos = new AtomicLong();
    private AtomicLong commitTimeNanos = new AtomicLong();
    private AtomicLong rollbackTimeNanos = new AtomicLong();
    private AtomicLong offHeapGets = new AtomicLong();
    private AtomicLong offHeapPuts = new AtomicLong();
    private AtomicLong offHeapRemoves = new AtomicLong();
    private AtomicLong offHeapEvicts = new AtomicLong();
    private AtomicLong offHeapHits = new AtomicLong();
    private AtomicLong offHeapMisses = new AtomicLong();
    private AtomicLong rebalancedKeys = new AtomicLong();
    private AtomicLong totalRebalancedBytes = new AtomicLong();
    private AtomicLong rebalanceStartTime = new AtomicLong(-1L);
    private AtomicLong estimatedRebalancingKeys = new AtomicLong();
    private HitRateMetrics rebalancingKeysRate = new HitRateMetrics(REBALANCE_RATE_INTERVAL, 20);
    private HitRateMetrics rebalancingBytesRate = new HitRateMetrics(REBALANCE_RATE_INTERVAL, 20);
    private AtomicLong rebalanceClearingPartitions = new AtomicLong();
    @GridToStringExclude
    private transient CacheMetricsImpl delegate;
    private GridCacheContext<?, ?> cctx;
    private GridCacheContext<?, ?> dhtCtx;
    private GridCacheWriteBehindStore store;

    public CacheMetricsImpl(GridCacheContext<?, ?> cctx) {
        assert (cctx != null);
        this.cctx = cctx;
        if (cctx.isNear()) {
            this.dhtCtx = cctx.near().dht().context();
        }
        if (cctx.store().store() instanceof GridCacheWriteBehindStore) {
            this.store = (GridCacheWriteBehindStore)cctx.store().store();
        }
        this.delegate = null;
    }

    public void delegate(CacheMetricsImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public String name() {
        return this.cctx.name();
    }

    @Override
    public long getOffHeapGets() {
        return this.offHeapGets.get();
    }

    @Override
    public long getOffHeapPuts() {
        return this.offHeapPuts.get();
    }

    @Override
    public long getOffHeapRemovals() {
        return this.offHeapRemoves.get();
    }

    @Override
    public long getOffHeapEvictions() {
        return this.offHeapEvicts.get();
    }

    @Override
    public long getOffHeapHits() {
        return this.offHeapHits.get();
    }

    @Override
    public float getOffHeapHitPercentage() {
        long hits0 = this.offHeapHits.get();
        long gets0 = this.offHeapGets.get();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getOffHeapMisses() {
        return this.offHeapMisses.get();
    }

    @Override
    public float getOffHeapMissPercentage() {
        long misses0 = this.offHeapMisses.get();
        long reads0 = this.offHeapGets.get();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getOffHeapEntriesCount() {
        return this.getEntriesStat().offHeapEntriesCount();
    }

    @Override
    public long getHeapEntriesCount() {
        return this.getEntriesStat().heapEntriesCount();
    }

    @Override
    public long getOffHeapPrimaryEntriesCount() {
        return this.getEntriesStat().offHeapPrimaryEntriesCount();
    }

    @Override
    public long getOffHeapBackupEntriesCount() {
        return this.getEntriesStat().offHeapBackupEntriesCount();
    }

    @Override
    public long getOffHeapAllocatedSize() {
        GridCacheAdapter<?, ?> cache = this.cctx.cache();
        return cache != null ? cache.offHeapAllocatedSize() : -1L;
    }

    @Override
    public int getSize() {
        return this.getEntriesStat().size();
    }

    @Override
    public long getCacheSize() {
        return this.getEntriesStat().cacheSize();
    }

    @Override
    public int getKeySize() {
        return this.getEntriesStat().keySize();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntriesStat().isEmpty();
    }

    @Override
    public int getDhtEvictQueueCurrentSize() {
        return -1;
    }

    @Override
    public int getTxCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxThreadMapSize() {
        return this.cctx.tm().threadMapSize();
    }

    @Override
    public int getTxXidMapSize() {
        return this.cctx.tm().idMapSize();
    }

    @Override
    public int getTxPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxCommittedVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxRolledbackVersionsSize() {
        return this.cctx.tm().completedVersionsSize();
    }

    @Override
    public int getTxDhtThreadMapSize() {
        return this.cctx.tm().threadMapSize();
    }

    @Override
    public int getTxDhtXidMapSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().idMapSize() : -1;
    }

    @Override
    public int getTxDhtCommitQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtPrepareQueueSize() {
        return 0;
    }

    @Override
    public int getTxDhtStartVersionCountsSize() {
        return 0;
    }

    @Override
    public int getTxDhtCommittedVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public int getTxDhtRolledbackVersionsSize() {
        return this.cctx.isNear() && this.dhtCtx != null ? this.dhtCtx.tm().completedVersionsSize() : -1;
    }

    @Override
    public boolean isWriteBehindEnabled() {
        return this.store != null;
    }

    @Override
    public int getWriteBehindFlushSize() {
        return this.store != null ? this.store.getWriteBehindFlushSize() : -1;
    }

    @Override
    public int getWriteBehindFlushThreadCount() {
        return this.store != null ? this.store.getWriteBehindFlushThreadCount() : -1;
    }

    @Override
    public long getWriteBehindFlushFrequency() {
        return this.store != null ? this.store.getWriteBehindFlushFrequency() : -1L;
    }

    @Override
    public int getWriteBehindStoreBatchSize() {
        return this.store != null ? this.store.getWriteBehindStoreBatchSize() : -1;
    }

    @Override
    public int getWriteBehindTotalCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindTotalCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindCriticalOverflowCount() {
        return this.store != null ? this.store.getWriteBehindCriticalOverflowCount() : -1;
    }

    @Override
    public int getWriteBehindErrorRetryCount() {
        return this.store != null ? this.store.getWriteBehindErrorRetryCount() : -1;
    }

    @Override
    public int getWriteBehindBufferSize() {
        return this.store != null ? this.store.getWriteBehindBufferSize() : -1;
    }

    @Override
    public float getAverageTxCommitTime() {
        long timeNanos = this.commitTimeNanos.get();
        long commitsCnt = this.txCommits.get();
        if (timeNanos == 0L || commitsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)commitsCnt / 1000.0f;
    }

    @Override
    public float getAverageTxRollbackTime() {
        long timeNanos = this.rollbackTimeNanos.get();
        long rollbacksCnt = this.txRollbacks.get();
        if (timeNanos == 0L || rollbacksCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)rollbacksCnt / 1000.0f;
    }

    @Override
    public long getCacheTxCommits() {
        return this.txCommits.get();
    }

    @Override
    public long getCacheTxRollbacks() {
        return this.txRollbacks.get();
    }

    public void clear() {
        this.reads.set(0L);
        this.writes.set(0L);
        this.rmCnt.set(0L);
        this.hits.set(0L);
        this.misses.set(0L);
        this.evictCnt.set(0L);
        this.txCommits.set(0L);
        this.txRollbacks.set(0L);
        this.putTimeNanos.set(0L);
        this.rmvTimeNanos.set(0L);
        this.getTimeNanos.set(0L);
        this.commitTimeNanos.set(0L);
        this.rollbackTimeNanos.set(0L);
        this.entryProcessorPuts.set(0L);
        this.entryProcessorRemovals.set(0L);
        this.entryProcessorReadOnlyInvocations.set(0L);
        this.entryProcessorMisses.set(0L);
        this.entryProcessorHits.set(0L);
        this.entryProcessorInvokeTimeNanos.set(0L);
        this.entryProcessorMaxInvocationTime.set(0L);
        this.entryProcessorMinInvocationTime.set(0L);
        this.offHeapGets.set(0L);
        this.offHeapPuts.set(0L);
        this.offHeapRemoves.set(0L);
        this.offHeapHits.set(0L);
        this.offHeapMisses.set(0L);
        this.offHeapEvicts.set(0L);
        this.clearRebalanceCounters();
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return this.hits.get();
    }

    @Override
    public float getCacheHitPercentage() {
        long hits0 = this.hits.get();
        long gets0 = this.reads.get();
        if (hits0 == 0L) {
            return 0.0f;
        }
        return (float)hits0 / (float)gets0 * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.misses.get();
    }

    @Override
    public float getCacheMissPercentage() {
        long misses0 = this.misses.get();
        long reads0 = this.reads.get();
        if (misses0 == 0L) {
            return 0.0f;
        }
        return (float)misses0 / (float)reads0 * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.reads.get();
    }

    @Override
    public long getCachePuts() {
        return this.writes.get();
    }

    @Override
    public long getEntryProcessorPuts() {
        return this.entryProcessorPuts.get();
    }

    @Override
    public long getEntryProcessorRemovals() {
        return this.entryProcessorRemovals.get();
    }

    @Override
    public long getEntryProcessorReadOnlyInvocations() {
        return this.entryProcessorReadOnlyInvocations.get();
    }

    @Override
    public long getEntryProcessorInvocations() {
        return this.entryProcessorReadOnlyInvocations.get() + this.entryProcessorPuts.get() + this.entryProcessorRemovals.get();
    }

    @Override
    public long getEntryProcessorHits() {
        return this.entryProcessorHits.get();
    }

    @Override
    public float getEntryProcessorHitPercentage() {
        long hits = this.entryProcessorHits.get();
        long totalInvocations = this.getEntryProcessorInvocations();
        if (hits == 0L) {
            return 0.0f;
        }
        return (float)hits / (float)totalInvocations * 100.0f;
    }

    @Override
    public long getEntryProcessorMisses() {
        return this.entryProcessorMisses.get();
    }

    @Override
    public float getEntryProcessorMissPercentage() {
        long misses = this.entryProcessorMisses.get();
        long totalInvocations = this.getEntryProcessorInvocations();
        if (misses == 0L) {
            return 0.0f;
        }
        return (float)misses / (float)totalInvocations * 100.0f;
    }

    @Override
    public float getEntryProcessorAverageInvocationTime() {
        long totalInvokes = this.getEntryProcessorInvocations();
        long timeNanos = this.entryProcessorInvokeTimeNanos.get();
        if (timeNanos == 0L || totalInvokes == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)totalInvokes / 1000.0f;
    }

    @Override
    public float getEntryProcessorMinInvocationTime() {
        return 1.0f * (float)this.entryProcessorMinInvocationTime.get() / 1000.0f;
    }

    @Override
    public float getEntryProcessorMaxInvocationTime() {
        return 1.0f * (float)this.entryProcessorMaxInvocationTime.get() / 1000.0f;
    }

    @Override
    public long getCacheRemovals() {
        return this.rmCnt.get();
    }

    @Override
    public long getCacheEvictions() {
        return this.evictCnt.get();
    }

    @Override
    public float getAverageGetTime() {
        long timeNanos = this.getTimeNanos.get();
        long readsCnt = this.reads.get();
        if (timeNanos == 0L || readsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)readsCnt / 1000.0f;
    }

    @Override
    public float getAveragePutTime() {
        long timeNanos = this.putTimeNanos.get();
        long putsCnt = this.writes.get();
        if (timeNanos == 0L || putsCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)putsCnt / 1000.0f;
    }

    @Override
    public float getAverageRemoveTime() {
        long timeNanos = this.rmvTimeNanos.get();
        long removesCnt = this.rmCnt.get();
        if (timeNanos == 0L || removesCnt == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)timeNanos / (float)removesCnt / 1000.0f;
    }

    public void onRead(boolean isHit) {
        this.reads.incrementAndGet();
        if (isHit) {
            this.hits.incrementAndGet();
        } else {
            this.misses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onRead(isHit);
        }
    }

    public void onInvokeUpdate(boolean isHit) {
        this.entryProcessorPuts.incrementAndGet();
        if (isHit) {
            this.entryProcessorHits.incrementAndGet();
        } else {
            this.entryProcessorMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onInvokeUpdate(isHit);
        }
    }

    public void onInvokeRemove(boolean isHit) {
        this.entryProcessorRemovals.incrementAndGet();
        if (isHit) {
            this.entryProcessorHits.incrementAndGet();
        } else {
            this.entryProcessorMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onInvokeRemove(isHit);
        }
    }

    public void onReadOnlyInvoke(boolean isHit) {
        this.entryProcessorReadOnlyInvocations.incrementAndGet();
        if (isHit) {
            this.entryProcessorHits.incrementAndGet();
        } else {
            this.entryProcessorMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onReadOnlyInvoke(isHit);
        }
    }

    public void addInvokeTimeNanos(long duration) {
        this.entryProcessorInvokeTimeNanos.addAndGet(duration);
        this.recalculateInvokeMinTimeNanos(duration);
        this.recalculateInvokeMaxTimeNanos(duration);
        if (this.delegate != null) {
            this.delegate.addInvokeTimeNanos(duration);
        }
    }

    private void recalculateInvokeMinTimeNanos(long duration) {
        long minTime = this.entryProcessorMinInvocationTime.longValue();
        while (!(minTime <= duration && minTime != 0L || this.entryProcessorMinInvocationTime.compareAndSet(minTime, duration))) {
            minTime = this.entryProcessorMinInvocationTime.longValue();
        }
    }

    private void recalculateInvokeMaxTimeNanos(long duration) {
        long maxTime = this.entryProcessorMaxInvocationTime.longValue();
        while (maxTime < duration && !this.entryProcessorMaxInvocationTime.compareAndSet(maxTime, duration)) {
            maxTime = this.entryProcessorMaxInvocationTime.longValue();
        }
    }

    public void onWrite() {
        this.writes.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onWrite();
        }
    }

    public void onRemove() {
        this.rmCnt.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onRemove();
        }
    }

    public void onEvict() {
        this.evictCnt.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onEvict();
        }
    }

    public void onTxCommit(long duration) {
        this.txCommits.incrementAndGet();
        this.commitTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.onTxCommit(duration);
        }
    }

    public void onTxRollback(long duration) {
        this.txRollbacks.incrementAndGet();
        this.rollbackTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.onTxRollback(duration);
        }
    }

    public void addGetTimeNanos(long duration) {
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addGetTimeNanos(duration);
        }
    }

    public void addPutTimeNanos(long duration) {
        this.putTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addPutTimeNanos(duration);
        }
    }

    public void addRemoveTimeNanos(long duration) {
        this.rmvTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveTimeNanos(duration);
        }
    }

    public void addRemoveAndGetTimeNanos(long duration) {
        this.rmvTimeNanos.addAndGet(duration);
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addRemoveAndGetTimeNanos(duration);
        }
    }

    public void addPutAndGetTimeNanos(long duration) {
        this.putTimeNanos.addAndGet(duration);
        this.getTimeNanos.addAndGet(duration);
        if (this.delegate != null) {
            this.delegate.addPutAndGetTimeNanos(duration);
        }
    }

    @Override
    public String getKeyType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getKeyType().getName() : null;
    }

    @Override
    public String getValueType() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null ? ccfg.getValueType().getName() : null;
    }

    @Override
    public boolean isReadThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isReadThrough();
    }

    @Override
    public boolean isWriteThrough() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isWriteThrough();
    }

    private boolean isValidForOperation(boolean read) {
        if (this.cctx.isLocal()) {
            return true;
        }
        try {
            GridDhtTopologyFuture fut = this.cctx.shared().exchange().lastFinishedFuture();
            return fut != null && fut.validateCache(this.cctx, false, read, null, null) == null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean isValidForReading() {
        return this.isValidForOperation(true);
    }

    @Override
    public boolean isValidForWriting() {
        return this.isValidForOperation(false);
    }

    @Override
    public boolean isStoreByValue() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isStoreByValue();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.cctx.statisticsEnabled();
    }

    @Override
    public boolean isManagementEnabled() {
        CacheConfiguration ccfg = this.cctx.config();
        return ccfg != null && ccfg.isManagementEnabled();
    }

    public EntriesStatMetrics getEntriesStat() {
        int owningPartCnt = 0;
        int movingPartCnt = 0;
        long offHeapEntriesCnt = 0L;
        long offHeapPrimaryEntriesCnt = 0L;
        long offHeapBackupEntriesCnt = 0L;
        long heapEntriesCnt = 0L;
        int size = 0;
        long sizeLong = 0L;
        try {
            if (this.cctx.isLocal()) {
                if (this.cctx.cache() != null) {
                    offHeapPrimaryEntriesCnt = offHeapEntriesCnt = this.cctx.cache().offHeapEntriesCount();
                    offHeapBackupEntriesCnt = offHeapEntriesCnt;
                    size = this.cctx.cache().size();
                    heapEntriesCnt = sizeLong = this.cctx.cache().sizeLong();
                }
            } else {
                AffinityTopologyVersion topVer = this.cctx.affinity().affinityTopologyVersion();
                Set<Integer> primaries = this.cctx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer);
                Set<Integer> backups = this.cctx.affinity().backupPartitions(this.cctx.localNodeId(), topVer);
                if (this.cctx.isNear() && this.cctx.cache() != null) {
                    heapEntriesCnt = this.cctx.cache().nearSize();
                }
                for (GridDhtLocalPartition part : this.cctx.topology().currentLocalPartitions()) {
                    GridDhtPartitionState partState = part.state();
                    if (partState == GridDhtPartitionState.OWNING) {
                        ++owningPartCnt;
                    }
                    if (partState == GridDhtPartitionState.MOVING) {
                        ++movingPartCnt;
                    }
                    if (this.cctx.cache() == null) continue;
                    long cacheSize = part.dataStore().cacheSize(this.cctx.cacheId());
                    offHeapEntriesCnt += cacheSize;
                    if (primaries.contains(part.id())) {
                        offHeapPrimaryEntriesCnt += cacheSize;
                    }
                    if (backups.contains(part.id())) {
                        offHeapBackupEntriesCnt += cacheSize;
                    }
                    size = (int)offHeapEntriesCnt;
                    heapEntriesCnt += (long)part.publicSize(this.cctx.cacheId());
                }
                sizeLong = offHeapEntriesCnt;
            }
        }
        catch (Exception e) {
            owningPartCnt = -1;
            movingPartCnt = 0;
            offHeapEntriesCnt = -1L;
            offHeapPrimaryEntriesCnt = -1L;
            offHeapBackupEntriesCnt = -1L;
            heapEntriesCnt = -1L;
            size = -1;
            sizeLong = -1L;
        }
        boolean isEmpty = offHeapEntriesCnt == 0L;
        EntriesStatMetrics stat = new EntriesStatMetrics();
        stat.offHeapEntriesCount(offHeapEntriesCnt);
        stat.offHeapPrimaryEntriesCount(offHeapPrimaryEntriesCnt);
        stat.offHeapBackupEntriesCount(offHeapBackupEntriesCnt);
        stat.heapEntriesCount(heapEntriesCnt);
        stat.size(size);
        stat.cacheSize(sizeLong);
        stat.keySize(size);
        stat.isEmpty(isEmpty);
        stat.totalPartitionsCount(owningPartCnt + movingPartCnt);
        stat.rebalancingPartitionsCount(movingPartCnt);
        return stat;
    }

    @Override
    public int getTotalPartitionsCount() {
        return this.getEntriesStat().totalPartitionsCount();
    }

    @Override
    public int getRebalancingPartitionsCount() {
        return this.getEntriesStat().rebalancingPartitionsCount();
    }

    @Override
    public long getRebalancedKeys() {
        return this.rebalancedKeys.get();
    }

    @Override
    public long getEstimatedRebalancingKeys() {
        return this.estimatedRebalancingKeys.get();
    }

    @Override
    public long getKeysToRebalanceLeft() {
        return Math.max(0L, this.estimatedRebalancingKeys.get() - this.rebalancedKeys.get());
    }

    @Override
    public long getRebalancingKeysRate() {
        return this.rebalancingKeysRate.getRate();
    }

    @Override
    public long getRebalancingBytesRate() {
        return this.rebalancingBytesRate.getRate();
    }

    public void clearRebalanceCounters() {
        this.estimatedRebalancingKeys.set(0L);
        this.rebalancedKeys.set(0L);
        this.totalRebalancedBytes.set(0L);
        this.rebalancingBytesRate.clear();
        this.rebalancingKeysRate.clear();
        this.rebalanceStartTime.set(-1L);
    }

    public void startRebalance(long delay) {
        this.rebalanceStartTime.set(delay + U.currentTimeMillis());
    }

    @Override
    public long estimateRebalancingFinishTime() {
        return this.getEstimatedRebalancingFinishTime();
    }

    @Override
    public long rebalancingStartTime() {
        return this.rebalanceStartTime.get();
    }

    @Override
    public long getEstimatedRebalancingFinishTime() {
        long rate = this.rebalancingKeysRate.getRate();
        return rate <= 0L ? -1L : this.getKeysToRebalanceLeft() / rate * (long)REBALANCE_RATE_INTERVAL + U.currentTimeMillis();
    }

    @Override
    public long getRebalancingStartTime() {
        return this.rebalanceStartTime.get();
    }

    @Override
    public long getRebalanceClearingPartitionsLeft() {
        return this.rebalanceClearingPartitions.get();
    }

    public void rebalanceClearingPartitions(int partitions) {
        this.rebalanceClearingPartitions.set(partitions);
    }

    public void onRebalancingKeysCountEstimateReceived(Long keysCnt) {
        if (keysCnt == null) {
            return;
        }
        this.estimatedRebalancingKeys.addAndGet(keysCnt);
    }

    public void onRebalanceKeyReceived() {
        this.rebalancedKeys.incrementAndGet();
        this.rebalancingKeysRate.onHit();
    }

    public void onRebalanceBatchReceived(long batchSize) {
        this.totalRebalancedBytes.addAndGet(batchSize);
        this.rebalancingBytesRate.onHits(batchSize);
    }

    public long getTotalAllocatedPages() {
        return 0L;
    }

    public long getTotalEvictedPages() {
        return 0L;
    }

    public void onOffHeapRead(boolean hit) {
        this.offHeapGets.incrementAndGet();
        if (hit) {
            this.offHeapHits.incrementAndGet();
        } else {
            this.offHeapMisses.incrementAndGet();
        }
        if (this.delegate != null) {
            this.delegate.onOffHeapRead(hit);
        }
    }

    public void onOffHeapWrite() {
        this.offHeapPuts.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapWrite();
        }
    }

    public void onOffHeapRemove() {
        this.offHeapRemoves.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapRemove();
        }
    }

    public void onOffHeapEvict() {
        this.offHeapEvicts.incrementAndGet();
        if (this.delegate != null) {
            this.delegate.onOffHeapEvict();
        }
    }

    public String toString() {
        return S.toString(CacheMetricsImpl.class, this);
    }

    public static class EntriesStatMetrics {
        private int totalPartsCnt;
        private int rebalancingPartsCnt;
        private long offHeapEntriesCnt;
        private long offHeapPrimaryEntriesCnt;
        private long offHeapBackupEntriesCnt;
        private long heapEntriesCnt;
        private int size;
        private long cacheSize;
        private int keySize;
        private boolean isEmpty;

        public int totalPartitionsCount() {
            return this.totalPartsCnt;
        }

        public void totalPartitionsCount(int totalPartsCnt) {
            this.totalPartsCnt = totalPartsCnt;
        }

        public int rebalancingPartitionsCount() {
            return this.rebalancingPartsCnt;
        }

        public void rebalancingPartitionsCount(int rebalancingPartsCnt) {
            this.rebalancingPartsCnt = rebalancingPartsCnt;
        }

        public long offHeapEntriesCount() {
            return this.offHeapEntriesCnt;
        }

        public void offHeapEntriesCount(long offHeapEntriesCnt) {
            this.offHeapEntriesCnt = offHeapEntriesCnt;
        }

        public long offHeapPrimaryEntriesCount() {
            return this.offHeapPrimaryEntriesCnt;
        }

        public void offHeapPrimaryEntriesCount(long offHeapPrimaryEntriesCnt) {
            this.offHeapPrimaryEntriesCnt = offHeapPrimaryEntriesCnt;
        }

        public long offHeapBackupEntriesCount() {
            return this.offHeapBackupEntriesCnt;
        }

        public void offHeapBackupEntriesCount(long offHeapBackupEntriesCnt) {
            this.offHeapBackupEntriesCnt = offHeapBackupEntriesCnt;
        }

        public long heapEntriesCount() {
            return this.heapEntriesCnt;
        }

        public void heapEntriesCount(long heapEntriesCnt) {
            this.heapEntriesCnt = heapEntriesCnt;
        }

        public int size() {
            return this.size;
        }

        public void size(int size) {
            this.size = size;
        }

        public int keySize() {
            return this.keySize;
        }

        public void keySize(int keySize) {
            this.keySize = keySize;
        }

        public long cacheSize() {
            return this.cacheSize;
        }

        public void cacheSize(long cacheSize) {
            this.cacheSize = cacheSize;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public void isEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
        }
    }
}

