/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDhtPartitionExchangeId
implements Message,
Comparable<GridDhtPartitionExchangeId>,
Externalizable {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private UUID nodeId;
    @GridToStringExclude
    private int evt;
    private AffinityTopologyVersion topVer;
    @GridDirectTransient
    private DiscoveryEvent discoEvt;

    public GridDhtPartitionExchangeId(UUID nodeId, int evt, AffinityTopologyVersion topVer) {
        this.nodeId = nodeId;
        this.evt = evt;
        this.topVer = topVer;
    }

    public GridDhtPartitionExchangeId(UUID nodeId, DiscoveryEvent discoEvt, AffinityTopologyVersion topVer) {
        assert (nodeId != null);
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        assert (discoEvt != null);
        this.nodeId = nodeId;
        this.evt = discoEvt.type();
        this.topVer = topVer;
        this.discoEvt = discoEvt;
        assert (this.evt == 11 || this.evt == 12 || this.evt == 10 || this.evt == 18);
    }

    public GridDhtPartitionExchangeId() {
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public int event() {
        return this.evt;
    }

    long eventTimestamp() {
        assert (this.discoEvt != null);
        return this.discoEvt.timestamp();
    }

    void discoveryEvent(DiscoveryEvent discoEvt) {
        this.discoEvt = discoEvt;
    }

    DiscoveryEvent discoveryEvent() {
        assert (this.discoEvt != null);
        return this.discoEvt;
    }

    public ClusterNode eventNode() {
        return this.discoEvt.eventNode();
    }

    public String discoveryEventName() {
        return U.gridEventName(this.evt);
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public boolean isJoined() {
        return this.evt == 10;
    }

    public boolean isLeft() {
        return this.evt == 11 || this.evt == 12;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        out.writeObject(this.topVer);
        out.writeInt(this.evt);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.topVer = (AffinityTopologyVersion)in.readObject();
        this.evt = in.readInt();
    }

    @Override
    public int compareTo(GridDhtPartitionExchangeId o) {
        if (o == this) {
            return 0;
        }
        return this.topVer.compareTo(o.topVer);
    }

    public int hashCode() {
        int res = this.nodeId.hashCode();
        res = 31 * res + this.evt;
        res = 31 * res + this.topVer.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        GridDhtPartitionExchangeId id = (GridDhtPartitionExchangeId)o;
        return this.evt == id.evt && this.topVer.equals(id.topVer) && this.nodeId.equals(id.nodeId);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("evt", this.evt)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeUuid("nodeId", this.nodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.evt = reader.readInt("evt");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.nodeId = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionExchangeId.class);
    }

    @Override
    public short directType() {
        return 87;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return S.toString(GridDhtPartitionExchangeId.class, this, "nodeId", U.id8(this.nodeId), "evt", U.gridEventName(this.evt));
    }
}

