/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBulkLoadAckResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV2;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV3;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaColumnsResultV4;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaIndexesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaParamsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaSchemasResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcMetaTablesResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteMultipleStatementsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;

public class JdbcResult
implements JdbcRawBinarylizable {
    static final byte QRY_EXEC = 2;
    static final byte QRY_FETCH = 3;
    static final byte QRY_META = 5;
    public static final byte BATCH_EXEC = 6;
    static final byte META_TABLES = 7;
    static final byte META_COLUMNS = 8;
    static final byte META_INDEXES = 9;
    static final byte META_PARAMS = 10;
    static final byte META_PRIMARY_KEYS = 11;
    static final byte META_SCHEMAS = 12;
    static final byte QRY_EXEC_MULT = 13;
    static final byte META_COLUMNS_V2 = 14;
    static final byte META_COLUMNS_V3 = 15;
    static final byte BULK_LOAD_ACK = 16;
    static final byte META_COLUMNS_V4 = 17;
    static final byte BATCH_EXEC_ORDERED = 18;
    private byte type;

    public JdbcResult(byte type) {
        this.type = type;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeByte(this.type);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
    }

    public static JdbcResult readResult(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        JdbcResult res;
        byte resId = reader.readByte();
        switch (resId) {
            case 2: {
                res = new JdbcQueryExecuteResult();
                break;
            }
            case 3: {
                res = new JdbcQueryFetchResult();
                break;
            }
            case 5: {
                res = new JdbcQueryMetadataResult();
                break;
            }
            case 6: {
                res = new JdbcBatchExecuteResult();
                break;
            }
            case 7: {
                res = new JdbcMetaTablesResult();
                break;
            }
            case 8: {
                res = new JdbcMetaColumnsResult();
                break;
            }
            case 9: {
                res = new JdbcMetaIndexesResult();
                break;
            }
            case 10: {
                res = new JdbcMetaParamsResult();
                break;
            }
            case 11: {
                res = new JdbcMetaPrimaryKeysResult();
                break;
            }
            case 12: {
                res = new JdbcMetaSchemasResult();
                break;
            }
            case 13: {
                res = new JdbcQueryExecuteMultipleStatementsResult();
                break;
            }
            case 14: {
                res = new JdbcMetaColumnsResultV2();
                break;
            }
            case 15: {
                res = new JdbcMetaColumnsResultV3();
                break;
            }
            case 16: {
                res = new JdbcBulkLoadAckResult();
                break;
            }
            case 17: {
                res = new JdbcMetaColumnsResultV4();
                break;
            }
            case 18: {
                res = new JdbcOrderedBatchExecuteResult();
                break;
            }
            default: {
                throw new IgniteException("Unknown SQL listener request ID: [request ID=" + resId + ']');
            }
        }
        res.readBinary(reader, ver);
        return res;
    }
}

