/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.terracotta.angela.common.AngelaProperties;

public class TerracottaCommandLineEnvironment {
    public static final TerracottaCommandLineEnvironment DEFAULT;
    private String javaVersion;
    private Set<String> javaVendors;
    private Set<String> javaOpts;

    private TerracottaCommandLineEnvironment(String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        TerracottaCommandLineEnvironment.validate(javaVersion, javaVendors, javaOpts);
        this.javaVersion = javaVersion;
        this.javaVendors = Collections.unmodifiableSet(new HashSet<String>(javaVendors));
        this.javaOpts = Collections.unmodifiableSet(new HashSet<String>(javaOpts));
    }

    private static void validate(String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        Objects.requireNonNull(javaVersion);
        Objects.requireNonNull(javaVendors);
        Objects.requireNonNull(javaOpts);
        if (javaVendors.stream().anyMatch(vendor -> vendor == null || vendor.isEmpty())) {
            throw new IllegalArgumentException("None of the java vendors can be null or empty");
        }
        if (javaOpts.stream().anyMatch(opt -> opt == null || opt.isEmpty())) {
            throw new IllegalArgumentException("None of the java opts can be null or empty");
        }
    }

    public TerracottaCommandLineEnvironment withJavaVersion(String javaVersion) {
        return new TerracottaCommandLineEnvironment(javaVersion, this.javaVendors, this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaVendors(String ... javaVendors) {
        return new TerracottaCommandLineEnvironment(this.javaVersion, new HashSet<String>(Arrays.asList(javaVendors)), this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaOpts(String ... javaOpts) {
        return new TerracottaCommandLineEnvironment(this.javaVersion, this.javaVendors, new HashSet<String>(Arrays.asList(javaOpts)));
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public Set<String> getJavaVendors() {
        return this.javaVendors;
    }

    public Set<String> getJavaOpts() {
        return this.javaOpts;
    }

    public String toString() {
        return "TerracottaCommandLineEnvironment{javaVersion='" + this.javaVersion + '\'' + ", javaVendors=" + this.javaVendors + ", javaOpts=" + this.javaOpts + '}';
    }

    static {
        String version = AngelaProperties.JAVA_VERSION.getValue();
        HashSet<String> vendors = AngelaProperties.JAVA_VENDOR.getValue().equals("") ? new HashSet() : Collections.singleton(AngelaProperties.JAVA_VENDOR.getValue());
        HashSet<String> opts = AngelaProperties.JAVA_OPTS.getValue().equals("") ? new HashSet() : Collections.singleton(AngelaProperties.JAVA_OPTS.getValue());
        DEFAULT = new TerracottaCommandLineEnvironment(version, vendors, opts);
    }
}

