/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.util.Objects;
import org.terracotta.angela.common.distribution.Distribution102Controller;
import org.terracotta.angela.common.distribution.Distribution107Controller;
import org.terracotta.angela.common.distribution.Distribution43Controller;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Version;

public class Distribution {
    private final Version version;
    private final PackageType packageType;
    private final LicenseType licenseType;

    public Distribution(Version version, PackageType packageType, LicenseType licenseType) {
        this.version = Objects.requireNonNull(version);
        this.packageType = Objects.requireNonNull(packageType);
        this.licenseType = this.validateLicenseType(version, licenseType);
    }

    private LicenseType validateLicenseType(Version version, LicenseType licenseType) {
        Objects.requireNonNull(licenseType);
        if (version.getMajor() == 4) {
            if (licenseType != LicenseType.GO && licenseType != LicenseType.MAX) {
                return this.throwException("Expected license of type '%s' or '%s for version: %s, but found: %s", new Object[]{LicenseType.GO, LicenseType.MAX, version, licenseType});
            }
        } else if (version.getMajor() == 3 || version.getMajor() == 5) {
            if (licenseType != LicenseType.TERRACOTTA_OS) {
                this.throwException("Expected license of type '%s' for version: %s, but found: %s", new Object[]{LicenseType.TERRACOTTA_OS, version, licenseType});
            }
        } else if (licenseType != LicenseType.TERRACOTTA) {
            this.throwException("Expected license of type '%s' for version: %s, but found: %s", new Object[]{LicenseType.TERRACOTTA, version, licenseType});
        }
        return licenseType;
    }

    private LicenseType throwException(String string, Object ... args) {
        throw new IllegalArgumentException(String.format(string, args));
    }

    public static Distribution distribution(Version version, PackageType packageType, LicenseType licenseType) {
        return new Distribution(version, packageType, licenseType);
    }

    public Version getVersion() {
        return this.version;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public DistributionController createDistributionController() {
        if (this.version.getMajor() == 10 && this.version.getMinor() >= 7 || this.version.getMajor() == 5 && this.version.getMinor() >= 7 || this.version.getMajor() == 3 && this.version.getMinor() == 8 && this.version.getRevision() > 1 || this.version.getMajor() == 3 && this.version.getMinor() >= 9) {
            return new Distribution107Controller(this);
        }
        if (this.version.getMajor() == 10 || this.version.getMajor() == 3) {
            return new Distribution102Controller(this);
        }
        if (this.version.getMinor() >= 3) {
            return new Distribution43Controller(this);
        }
        throw new IllegalStateException("Cannot create a DistributionController for version: " + this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distribution that = (Distribution)o;
        return Objects.equals(this.version, that.version) && this.packageType == that.packageType && this.licenseType == that.licenseType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.packageType, this.licenseType});
    }

    public String toString() {
        return "Distribution{version=" + this.version + ", packageType=" + (Object)((Object)this.packageType) + ", licenseType=" + (Object)((Object)this.licenseType) + '}';
    }
}

