/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TsaStripeConfig {
    private List<String> hostnames;
    private TsaOffheapConfig tsaOffheapConfig = null;
    private List<TsaDataDirectory> tsaDataDirectory = new ArrayList<TsaDataDirectory>();
    private String persistenceDataName = null;

    public TsaStripeConfig(List<String> hostnames) {
        this.hostnames = hostnames;
    }

    public static TsaStripeConfig stripe(String hostname, int serverCount) {
        if (serverCount < 1) {
            throw new IllegalArgumentException("Server count can be lower than 1 in a Tsa Stripe");
        }
        ArrayList<String> hostnamesList = new ArrayList<String>();
        for (int i = 0; i < serverCount; ++i) {
            hostnamesList.add(hostname);
        }
        return new TsaStripeConfig(hostnamesList);
    }

    public static TsaStripeConfig stripe(String hostname, String ... hostnames) {
        ArrayList<String> hostnamesList = new ArrayList<String>();
        hostnamesList.add(hostname);
        Collections.addAll(hostnamesList, hostnames);
        return new TsaStripeConfig(hostnamesList);
    }

    public TsaStripeConfig offheap(String resourceName, String size, String unit) {
        this.tsaOffheapConfig = new TsaOffheapConfig(resourceName, size, unit);
        return this;
    }

    public TsaStripeConfig data(String dataName, String pathname) {
        return this.data(dataName, pathname, false);
    }

    public TsaStripeConfig data(String dataName, String pathname, boolean useForPlatform) {
        this.tsaDataDirectory.add(new TsaDataDirectory(dataName, pathname, useForPlatform));
        return this;
    }

    public TsaStripeConfig persistence(String dataName) {
        this.persistenceDataName = dataName;
        return this;
    }

    public List<String> getHostnames() {
        return this.hostnames;
    }

    public TsaOffheapConfig getTsaOffheapConfig() {
        return this.tsaOffheapConfig;
    }

    public List<TsaDataDirectory> getTsaDataDirectoryList() {
        return this.tsaDataDirectory;
    }

    public String getPersistenceDataName() {
        return this.persistenceDataName;
    }

    public class TsaDataDirectory {
        private final String dataName;
        private final String location;
        private final boolean useForPlatform;

        public TsaDataDirectory(String dataName, String location, boolean useForPlatform) {
            this.dataName = dataName;
            this.location = location;
            this.useForPlatform = useForPlatform;
        }

        public String getDataName() {
            return this.dataName;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isUseForPlatform() {
            return this.useForPlatform;
        }
    }

    public class TsaOffheapConfig {
        private final String resourceName;
        private final String size;
        private final String unit;

        public TsaOffheapConfig(String resourceName, String size, String unit) {
            this.resourceName = resourceName;
            this.size = size;
            this.unit = unit;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getSize() {
            return this.size;
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

