/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.lang.IgniteFuture;
import org.terracotta.angela.common.topology.InstanceId;

public class IgniteCommonHelper {
    public static BlockingQueue<Object> fileTransferQueue(Ignite ignite, InstanceId instanceId) {
        return ignite.queue(instanceId + "@file-transfer-queue", 100, new CollectionConfiguration());
    }

    public static void checkForDuplicateAgent(Ignite ignite, String nodeName) {
        ClusterGroup location = ignite.cluster().forAttribute("nodename", nodeName);
        IgniteFuture future = ignite.compute(location).broadcastAsync(() -> 0);
        Collection results = future.get(60L, TimeUnit.SECONDS);
        if (results.size() != 1) {
            throw new IllegalStateException("Node with name [" + nodeName + "] already exists on the network, refusing to duplicate it.");
        }
    }
}

