/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(RetryUtils.class);

    public static boolean waitFor(Callable<Boolean> condition, int maxWaitTimeMillis) {
        int timeRemaining = maxWaitTimeMillis;
        ExecutorService executorService = Executors.newSingleThreadExecutor(Thread::new);
        boolean success = false;
        for (int currRetryTime = Math.min(maxWaitTimeMillis, 100); currRetryTime <= maxWaitTimeMillis; currRetryTime *= 2) {
            Future<Boolean> future;
            long timeout = Math.min(currRetryTime, timeRemaining);
            if (RetryUtils.getResult(timeout, future = executorService.submit(condition)).booleanValue()) {
                logger.info("Condition became true after {}ms ", (Object)currRetryTime);
                success = true;
                break;
            }
            timeRemaining -= currRetryTime;
        }
        RetryUtils.cleanup(executorService);
        return success;
    }

    private static Boolean getResult(long timeout, Future<Boolean> future) {
        try {
            Boolean result = future.get(timeout, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    private static void cleanup(ExecutorService executorService) {
        try {
            executorService.shutdownNow();
            executorService.awaitTermination(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

