/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.internal.binary.streams.BinaryAbstractOutputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public class BinaryOffheapOutputStream
extends BinaryAbstractOutputStream {
    private long ptr;
    private int cap;

    public BinaryOffheapOutputStream(int cap) {
        this(0L, cap);
    }

    public BinaryOffheapOutputStream(long ptr, int cap) {
        this.ptr = ptr == 0L ? this.allocate(cap) : ptr;
        this.cap = cap;
    }

    @Override
    public void close() {
        this.release(this.ptr);
    }

    @Override
    public void ensureCapacity(int cnt) {
        if (cnt > this.cap) {
            int newCap = BinaryOffheapOutputStream.capacity(this.cap, cnt);
            this.ptr = this.reallocate(this.ptr, newCap);
            this.cap = newCap;
        }
    }

    @Override
    public byte[] array() {
        return this.arrayCopy();
    }

    @Override
    public byte[] arrayCopy() {
        byte[] res = new byte[this.pos];
        GridUnsafe.copyOffheapHeap(this.ptr, res, GridUnsafe.BYTE_ARR_OFF, this.pos);
        return res;
    }

    public long pointer() {
        return this.ptr;
    }

    @Override
    public int capacity() {
        return this.cap;
    }

    @Override
    protected void writeByteAndShift(byte val) {
        GridUnsafe.putByte(this.ptr + (long)this.pos++, val);
    }

    @Override
    protected void copyAndShift(Object src, long offset, int len) {
        GridUnsafe.copyHeapOffheap(src, offset, this.ptr + (long)this.pos, len);
        this.shift(len);
    }

    @Override
    protected void writeShortFast(short val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(addr, val);
        } else {
            GridUnsafe.putShort(addr, val);
        }
    }

    @Override
    protected void writeCharFast(char val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(addr, val);
        } else {
            GridUnsafe.putChar(addr, val);
        }
    }

    @Override
    protected void writeIntFast(int val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(addr, val);
        } else {
            GridUnsafe.putInt(addr, val);
        }
    }

    @Override
    protected void writeLongFast(long val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(addr, val);
        } else {
            GridUnsafe.putLong(addr, val);
        }
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public void unsafeWriteByte(byte val) {
        GridUnsafe.putByte(this.ptr + (long)this.pos++, val);
    }

    @Override
    public void unsafeWriteShort(short val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(addr, val);
        } else {
            GridUnsafe.putShort(addr, val);
        }
        this.shift(2);
    }

    @Override
    public void unsafeWriteShort(int pos, short val) {
        long addr = this.ptr + (long)pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(addr, val);
        } else {
            GridUnsafe.putShort(addr, val);
        }
    }

    @Override
    public void unsafeWriteChar(char val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(addr, val);
        } else {
            GridUnsafe.putChar(addr, val);
        }
        this.shift(2);
    }

    @Override
    public void unsafeWriteInt(int val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(addr, val);
        } else {
            GridUnsafe.putInt(addr, val);
        }
        this.shift(4);
    }

    @Override
    public void unsafeWriteInt(int pos, int val) {
        long addr = this.ptr + (long)pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(addr, val);
        } else {
            GridUnsafe.putInt(addr, val);
        }
    }

    @Override
    public void unsafeWriteLong(long val) {
        long addr = this.ptr + (long)this.pos;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(addr, val);
        } else {
            GridUnsafe.putLong(addr, val);
        }
        this.shift(8);
    }

    protected long allocate(int cap) {
        return GridUnsafe.allocateMemory(cap);
    }

    protected long reallocate(long ptr, int cap) {
        return GridUnsafe.reallocateMemory(ptr, cap);
    }

    protected void release(long ptr) {
        GridUnsafe.freeMemory(ptr);
    }
}

