/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.visor.verify.VisorContentionTask;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskArg;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskResult;

public class CacheContention
implements Command<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String description = "Show the keys that are point of contention for multiple transactions.";
        CacheCommands.usageCache(logger, CacheSubcommands.CONTENTION, description, null, "minQueueSize", CacheCommands.OP_NODE_ID, CommandLogger.optional("maxPrint"));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        VisorContentionTaskResult res;
        VisorContentionTaskArg taskArg = new VisorContentionTaskArg(this.args.minQueueSize(), this.args.maxPrint());
        UUID nodeId = this.args.nodeId() == null ? TaskExecutor.BROADCAST_UUID : this.args.nodeId();
        try (GridClient client = Command.startClient(clientCfg);){
            res = (VisorContentionTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorContentionTask.class.getName(), taskArg, nodeId, clientCfg);
        }
        CommandLogger.printErrors(res.exceptions(), "Contention check failed on nodes:", logger);
        for (ContentionInfo info : res.getInfos()) {
            info.print();
        }
        return res;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        int minQueueSize = Integer.parseInt(argIter.nextArg("Min queue size expected"));
        UUID nodeId = null;
        if (argIter.hasNextSubArg()) {
            nodeId = UUID.fromString(argIter.nextArg(""));
        }
        int maxPrint = 10;
        if (argIter.hasNextSubArg()) {
            maxPrint = Integer.parseInt(argIter.nextArg(""));
        }
        this.args = new Arguments(nodeId, minQueueSize, maxPrint);
    }

    @Override
    public String name() {
        return CacheSubcommands.CONTENTION.text().toUpperCase();
    }

    public class Arguments {
        private UUID nodeId;
        private int minQueueSize;
        private int maxPrint;

        public Arguments(UUID nodeId, int minQueueSize, int maxPrint) {
            this.nodeId = nodeId;
            this.minQueueSize = minQueueSize;
            this.maxPrint = maxPrint;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public int minQueueSize() {
            return this.minQueueSize;
        }

        public int maxPrint() {
            return this.maxPrint;
        }
    }
}

