/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.ExecutorAwareMessage;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridIoMessage
implements Message {
    public static final Integer STRIPE_DISABLED_PART = Integer.MIN_VALUE;
    private static final long serialVersionUID = 0L;
    private byte plc;
    @GridToStringInclude
    @GridDirectTransient
    private Object topic;
    private byte[] topicBytes;
    private int topicOrd = -1;
    private boolean ordered;
    private long timeout;
    private boolean skipOnTimeout;
    private Message msg;

    public GridIoMessage() {
    }

    public GridIoMessage(byte plc, Object topic, int topicOrd, Message msg, boolean ordered, long timeout, boolean skipOnTimeout) {
        assert (topic != null);
        assert (topicOrd <= 127);
        assert (msg != null);
        this.plc = plc;
        this.msg = msg;
        this.topic = topic;
        this.topicOrd = topicOrd;
        this.ordered = ordered;
        this.timeout = timeout;
        this.skipOnTimeout = skipOnTimeout;
    }

    byte policy() {
        return this.plc;
    }

    Object topic() {
        return this.topic;
    }

    void topic(Object topic) {
        this.topic = topic;
    }

    byte[] topicBytes() {
        return this.topicBytes;
    }

    void topicBytes(byte[] topicBytes) {
        this.topicBytes = topicBytes;
    }

    int topicOrdinal() {
        return this.topicOrd;
    }

    public Message message() {
        return this.msg;
    }

    public long timeout() {
        return this.timeout;
    }

    public boolean skipOnTimeout() {
        return this.skipOnTimeout;
    }

    boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public void onAckReceived() {
        this.msg.onAckReceived();
    }

    public boolean equals(Object obj) {
        throw new AssertionError();
    }

    public int hashCode() {
        throw new AssertionError();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("msg", this.msg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("ordered", this.ordered)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByte("plc", this.plc)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeBoolean("skipOnTimeout", this.skipOnTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByteArray("topicBytes", this.topicBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeInt("topicOrd", this.topicOrd)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg = reader.readMessage("msg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.ordered = reader.readBoolean("ordered");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.plc = reader.readByte("plc");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.skipOnTimeout = reader.readBoolean("skipOnTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.topicBytes = reader.readByteArray("topicBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.topicOrd = reader.readInt("topicOrd");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridIoMessage.class);
    }

    @Override
    public short directType() {
        return 8;
    }

    @Override
    public byte fieldsCount() {
        return 7;
    }

    public int partition() {
        if (this.msg instanceof GridCacheMessage) {
            return ((GridCacheMessage)this.msg).partition();
        }
        if (this.msg instanceof DataStreamerRequest) {
            return ((DataStreamerRequest)this.msg).partition();
        }
        return STRIPE_DISABLED_PART;
    }

    @Nullable
    public String executorName() {
        if (this.msg instanceof ExecutorAwareMessage) {
            return ((ExecutorAwareMessage)this.msg).executorName();
        }
        return null;
    }

    public String toString() {
        return S.toString(GridIoMessage.class, this);
    }
}

