/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IdealAffinityAssignment {
    private final AffinityTopologyVersion topologyVersion;
    private final List<List<ClusterNode>> assignment;
    private final Map<Object, Set<Integer>> idealPrimaries;

    private IdealAffinityAssignment(AffinityTopologyVersion topologyVersion, List<List<ClusterNode>> assignment, Map<Object, Set<Integer>> idealPrimaries) {
        this.topologyVersion = topologyVersion;
        this.assignment = assignment;
        this.idealPrimaries = idealPrimaries;
    }

    public Set<Integer> idealPrimaries(ClusterNode clusterNode) {
        Object consistentId = clusterNode.consistentId();
        assert (consistentId != null) : clusterNode;
        return this.idealPrimaries.getOrDefault(consistentId, Collections.emptySet());
    }

    public ClusterNode currentPrimary(int partition) {
        return this.assignment.get(partition).get(0);
    }

    public List<List<ClusterNode>> assignment() {
        return this.assignment;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topologyVersion;
    }

    private static Map<Object, Set<Integer>> calculatePrimaries(@Nullable List<ClusterNode> nodes, List<List<ClusterNode>> assignment) {
        int nodesSize = nodes != null ? nodes.size() : 100;
        HashMap<Object, Set<Integer>> primaryPartitions = U.newHashMap(nodesSize);
        int size = assignment.size();
        for (int p = 0; p < size; ++p) {
            List<ClusterNode> affinityNodes = assignment.get(p);
            if (affinityNodes.isEmpty()) continue;
            ClusterNode primary = affinityNodes.get(0);
            primaryPartitions.computeIfAbsent(primary.consistentId(), id -> new HashSet(U.capacity(size / nodesSize * 2))).add(p);
        }
        return primaryPartitions;
    }

    public static IdealAffinityAssignment create(AffinityTopologyVersion topVer, List<List<ClusterNode>> assignment) {
        return IdealAffinityAssignment.create(topVer, null, assignment);
    }

    public static IdealAffinityAssignment create(AffinityTopologyVersion topVer, @Nullable List<ClusterNode> nodes, List<List<ClusterNode>> assignment) {
        return new IdealAffinityAssignment(topVer, assignment, IdealAffinityAssignment.calculatePrimaries(nodes, assignment));
    }

    public static IdealAffinityAssignment createWithPreservedPrimaries(AffinityTopologyVersion topVer, List<List<ClusterNode>> assignment, IdealAffinityAssignment previousAssignment) {
        return new IdealAffinityAssignment(topVer, assignment, previousAssignment.idealPrimaries);
    }
}

